/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.NotFoundException;

public abstract class MachoRelocationHandler
implements ExtensionPoint {
    public abstract boolean canRelocate(MachHeader var1);

    public abstract boolean isPairedRelocation(RelocationInfo var1);

    public abstract void relocate(MachoRelocation var1) throws MemoryAccessException, NotFoundException;

    public static long read(MachoRelocation relocation) throws MemoryAccessException {
        Memory mem = relocation.getProgram().getMemory();
        int len = relocation.getRelocationInfo().getLength();
        Address addr = relocation.getRelocationAddress();
        if (len == 3) {
            return mem.getLong(addr);
        }
        if (len == 2) {
            return mem.getInt(addr);
        }
        if (len == 1) {
            return mem.getShort(addr);
        }
        return mem.getByte(addr);
    }

    public static void write(MachoRelocation relocation, long value) throws MemoryAccessException {
        Memory mem = relocation.getProgram().getMemory();
        int len = relocation.getRelocationInfo().getLength();
        Address addr = relocation.getRelocationAddress();
        if (len == 3) {
            mem.setLong(addr, value);
        } else if (len == 2) {
            mem.setInt(addr, (int)value);
        } else if (len == 1) {
            mem.setShort(addr, (short)value);
        } else {
            mem.setByte(addr, (byte)value);
        }
    }
}

