/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.label.LabelHistoryListener;
import ghidra.app.plugin.core.label.LabelHistoryPanel;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.util.List;

public class LabelHistoryDialog
extends DialogComponentProvider
implements LabelHistoryListener {
    private final PluginTool tool;

    public LabelHistoryDialog(PluginTool tool, Program program, Address addr, List<LabelHistory> list) {
        super((String)(addr != null ? "Show Label History for " + addr : "Show Label History"), true);
        this.tool = tool;
        this.addWorkPanel(new LabelHistoryPanel(program, list, null));
        this.initialize();
    }

    public LabelHistoryDialog(PluginTool tool, Program program, String title, List<LabelHistory> list) {
        super(title, true);
        this.tool = tool;
        this.addWorkPanel(new LabelHistoryPanel(program, list, this));
        this.initialize();
    }

    private void initialize() {
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "Show_Label_History"));
    }

    @Override
    public void addressSelected(Program program, Address addr) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo((ProgramLocation)new CodeUnitLocation(program, addr, null, 0, 0, 0));
        }
    }
}

