/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.util.HTMLUtilities;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class FilterPointersAction
extends ToggleDockingAction {
    private static final Icon FILTER_POINTERS_ICON = ResourceManager.loadImage((String)"images/FilterPointers.png");
    private static final Icon POINTER_ICON = ResourceManager.loadImage((String)"images/fingerPointer.png");

    public FilterPointersAction(DataTypeManagerPlugin plugin) {
        super("Filter Pointers", plugin.getName());
        this.setToolBarData(new ToolBarData(FILTER_POINTERS_ICON, "filters"));
        this.setDescription(HTMLUtilities.toHTML((String)"Toggle whether or not Pointers are\ndisplayed in the Data Type Manager tree."));
        this.setSelected(true);
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DataTypesActionContext;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        List expandedPaths = gtree.getExpandedPaths(gtree.getViewRoot());
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        gtree.enablePointerFilter(this.isSelected());
        gtree.expandPaths(expandedPaths);
        gtree.setSelectionPaths(selectionPaths);
    }

    public void setSelected(boolean selected) {
        this.getToolBarData().setIcon(selected ? FILTER_POINTERS_ICON : POINTER_ICON);
        super.setSelected(selected);
    }
}

