/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;

public class RenameTreeCmd
implements Command {
    private String oldName;
    private String newName;
    private Program program;
    private String statusMsg;

    public RenameTreeCmd(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    public boolean applyTo(DomainObject obj) {
        this.program = (Program)obj;
        Listing listing = this.program.getListing();
        try {
            listing.renameTree(this.oldName, this.newName);
            return true;
        }
        catch (DuplicateNameException e) {
            this.statusMsg = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Rename Tree View";
    }
}

