/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.InlineMethodResolver;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.OdexHeader;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;

public class DeodexUtil {
    public static final int Virtual = 0;
    public static final int Direct = 1;
    public static final int Static = 2;
    private final InlineMethodResolver inlineMethodResolver;
    public final DexFile dexFile;
    private static final Pattern shortMethodPattern = Pattern.compile("([^(]+)\\(([^)]*)\\)(.+)");

    public DeodexUtil(DexFile dexFile) {
        this.dexFile = dexFile;
        OdexHeader odexHeader = dexFile.getOdexHeader();
        if (odexHeader == null) {
            assert (false);
            throw new RuntimeException("Cannot create a DeodexUtil object for a dex file without an odex header");
        }
        this.inlineMethodResolver = InlineMethodResolver.createInlineMethodResolver(this, odexHeader.version);
    }

    public DeodexUtil(DexFile dexFile, InlineMethodResolver inlineMethodResolver) {
        this.dexFile = dexFile;
        this.inlineMethodResolver = inlineMethodResolver;
    }

    public InlineMethod lookupInlineMethod(AnalyzedInstruction instruction) {
        return this.inlineMethodResolver.resolveExecuteInline(instruction);
    }

    public FieldIdItem lookupField(ClassPath.ClassDef accessingClass, ClassPath.ClassDef instanceClass, int fieldOffset) {
        ClassPath.FieldDef field = instanceClass.getInstanceField(fieldOffset);
        if (field == null) {
            return null;
        }
        return this.parseAndResolveField(accessingClass, instanceClass, field);
    }

    public MethodIdItem lookupVirtualMethod(ClassPath.ClassDef accessingClass, ClassPath.ClassDef instanceClass, int methodIndex) {
        String method = instanceClass.getVirtualMethod(methodIndex);
        if (method == null) {
            return null;
        }
        Matcher m = shortMethodPattern.matcher(method);
        if (!m.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + method);
        }
        String methodName = m.group(1);
        String methodParams = m.group(2);
        String methodRet = m.group(3);
        if (instanceClass instanceof ClassPath.UnresolvedClassDef) {
            instanceClass = ClassPath.getClassDef("Ljava/lang/Object;");
        } else if (instanceClass.isInterface()) {
            instanceClass = instanceClass.getSuperclass();
            assert (instanceClass != null);
        }
        return this.parseAndResolveMethod(accessingClass, instanceClass, methodName, methodParams, methodRet);
    }

    private MethodIdItem parseAndResolveMethod(ClassPath.ClassDef accessingClass, ClassPath.ClassDef definingClass, String methodName, String methodParams, String methodRet) {
        StringIdItem methodNameItem = StringIdItem.lookupStringIdItem(this.dexFile, methodName);
        if (methodNameItem == null) {
            return null;
        }
        LinkedList<TypeIdItem> paramList = new LinkedList<TypeIdItem>();
        for (int i = 0; i < methodParams.length(); ++i) {
            TypeIdItem typeIdItem;
            switch (methodParams.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, i + 1));
                    break;
                }
                case 'L': {
                    int end = methodParams.indexOf(59, i);
                    if (end == -1) {
                        throw new RuntimeException("invalid parameter in the method");
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, end + 1));
                    i = end;
                    break;
                }
                case '[': {
                    int typeStart;
                    int end;
                    for (typeStart = i + 1; typeStart < methodParams.length() && methodParams.charAt(typeStart) == '['; ++typeStart) {
                    }
                    switch (methodParams.charAt(typeStart)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            end = typeStart;
                            break;
                        }
                        case 'L': {
                            end = methodParams.indexOf(59, typeStart);
                            if (end != -1) break;
                            throw new RuntimeException("invalid parameter in the method");
                        }
                        default: {
                            throw new RuntimeException("invalid parameter in the method");
                        }
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, end + 1));
                    i = end;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid parameter in the method");
                }
            }
            if (typeIdItem == null) {
                return null;
            }
            paramList.add(typeIdItem);
        }
        TypeListItem paramListItem = null;
        if (paramList.size() > 0 && (paramListItem = TypeListItem.lookupTypeListItem(this.dexFile, paramList)) == null) {
            return null;
        }
        TypeIdItem retType = TypeIdItem.lookupTypeIdItem(this.dexFile, methodRet);
        if (retType == null) {
            return null;
        }
        ProtoIdItem protoItem = ProtoIdItem.lookupProtoIdItem(this.dexFile, retType, paramListItem);
        if (protoItem == null) {
            return null;
        }
        ClassPath.ClassDef methodClassDef = definingClass;
        do {
            MethodIdItem methodIdItem;
            TypeIdItem classTypeItem;
            if ((classTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodClassDef.getClassType())) == null || (methodIdItem = MethodIdItem.lookupMethodIdItem(this.dexFile, classTypeItem, protoItem, methodNameItem)) == null || !DeodexUtil.checkClassAccess(accessingClass, methodClassDef)) continue;
            return methodIdItem;
        } while ((methodClassDef = methodClassDef.getSuperclass()) != null);
        return null;
    }

    private static boolean checkClassAccess(ClassPath.ClassDef accessingClass, ClassPath.ClassDef definingClass) {
        return definingClass.isPublic() || DeodexUtil.getPackage(accessingClass.getClassType()).equals(DeodexUtil.getPackage(definingClass.getClassType()));
    }

    private static String getPackage(String classRef) {
        int lastSlash = classRef.lastIndexOf(47);
        if (lastSlash < 0) {
            return "";
        }
        return classRef.substring(1, lastSlash);
    }

    private FieldIdItem parseAndResolveField(ClassPath.ClassDef accessingClass, ClassPath.ClassDef instanceClass, ClassPath.FieldDef field) {
        ClassPath.ClassDef fieldClass;
        String definingClass = field.definingClass;
        String fieldName = field.name;
        String fieldType = field.type;
        StringIdItem fieldNameItem = StringIdItem.lookupStringIdItem(this.dexFile, fieldName);
        if (fieldNameItem == null) {
            return null;
        }
        TypeIdItem fieldTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, fieldType);
        if (fieldTypeItem == null) {
            return null;
        }
        ArrayList<ClassPath.ClassDef> parents = new ArrayList<ClassPath.ClassDef>();
        parents.add(fieldClass);
        for (fieldClass = instanceClass; fieldClass != null && !fieldClass.getClassType().equals(definingClass); fieldClass = fieldClass.getSuperclass()) {
            parents.add(fieldClass);
        }
        for (int i = parents.size() - 1; i >= 0; --i) {
            FieldIdItem fieldIdItem;
            fieldClass = (ClassPath.ClassDef)parents.get(i);
            TypeIdItem classTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, fieldClass.getClassType());
            if (classTypeItem == null || (fieldIdItem = FieldIdItem.lookupFieldIdItem(this.dexFile, classTypeItem, fieldTypeItem, fieldNameItem)) == null || !DeodexUtil.checkClassAccess(accessingClass, fieldClass)) continue;
            return fieldIdItem;
        }
        return null;
    }

    public static class InlineMethod {
        public final int methodType;
        public final String classType;
        public final String methodName;
        public final String parameters;
        public final String returnType;
        private MethodIdItem methodIdItem = null;

        InlineMethod(int methodType, String classType, String methodName, String parameters, String returnType) {
            this.methodType = methodType;
            this.classType = classType;
            this.methodName = methodName;
            this.parameters = parameters;
            this.returnType = returnType;
        }

        public MethodIdItem getMethodIdItem(DeodexUtil deodexUtil) {
            if (this.methodIdItem == null) {
                this.loadMethod(deodexUtil);
            }
            return this.methodIdItem;
        }

        private void loadMethod(DeodexUtil deodexUtil) {
            ClassPath.ClassDef classDef = ClassPath.getClassDef(this.classType);
            this.methodIdItem = deodexUtil.parseAndResolveMethod(classDef, classDef, this.methodName, this.parameters, this.returnType);
        }

        public String getMethodString() {
            return String.format("%s->%s(%s)%s", this.classType, this.methodName, this.parameters, this.returnType);
        }
    }
}

