/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import com.google.common.collect.Range;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.model.Trace;

public interface TraceReference
extends Reference {
    public Trace getTrace();

    public Range<Long> getLifespan();

    public long getStartSnap();

    public void setPrimary(boolean var1);

    public void setReferenceType(RefType var1);

    public void setAssociatedSymbol(Symbol var1);

    public void clearAssociatedSymbol();

    default public Symbol getAssociatedSymbol() {
        long id = this.getSymbolID();
        return id == -1L ? null : this.getTrace().getSymbolManager().getSymbolByID(id);
    }

    default public boolean isMnemonicReference() {
        return !this.isOperandReference();
    }

    default public boolean isOperandReference() {
        return this.getOperandIndex() >= 0;
    }

    default public boolean isStackReference() {
        return false;
    }

    default public boolean isExternalReference() {
        return false;
    }

    default public boolean isEntryPointReference() {
        return false;
    }

    default public boolean isMemoryReference() {
        return this.getToAddress().isMemoryAddress();
    }

    default public boolean isRegisterReference() {
        return this.getToAddress().isRegisterAddress();
    }

    default public boolean isOffsetReference() {
        return false;
    }

    default public boolean isShiftedReference() {
        return false;
    }

    default public int compareTo(Reference that) {
        int result = this.getFromAddress().compareTo((Object)that.getFromAddress());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.getOperandIndex(), that.getOperandIndex());
        if (result != 0) {
            return result;
        }
        result = this.getToAddress().compareTo((Object)that.getToAddress());
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public void delete();
}

