/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.program.AbstractDBTraceProgramViewListing;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewFragment;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.ComparatorMath;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DBTraceProgramViewRootModule
implements ProgramModule {
    public static final ProgramModule[] EMPTY_MODULE_ARRAY = new ProgramModule[0];
    protected final DBTraceProgramView program;
    protected final AbstractDBTraceProgramViewListing listing;

    public DBTraceProgramViewRootModule(AbstractDBTraceProgramViewListing listing) {
        this.program = listing.program;
        this.listing = listing;
    }

    public String getComment() {
        return "root";
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "Trace Tree";
    }

    public void setName(String name) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public boolean contains(CodeUnit codeUnit) {
        return true;
    }

    public int getNumParents() {
        return 0;
    }

    public ProgramModule[] getParents() {
        return EMPTY_MODULE_ARRAY;
    }

    public String[] getParentNames() {
        return AbstractDBTraceProgramViewListing.EMPTY_STRING_ARRAY;
    }

    public String getTreeName() {
        return "Trace Tree";
    }

    public boolean contains(ProgramFragment fragment) {
        return true;
    }

    public boolean contains(ProgramModule module) {
        return true;
    }

    public int getNumChildren() {
        return this.program.trace.getMemoryManager().getRegionsAtSnap(this.program.snap).size();
    }

    public Group[] getChildren() {
        try (LockHold hold = LockHold.lock((Lock)this.program.trace.getReadWriteLock().readLock());){
            ArrayList frags = new ArrayList();
            this.program.memory.forVisibleRegions(region -> frags.add(this.listing.fragmentsByRegion.computeIfAbsent((DBTraceMemoryRegion)region, r -> new DBTraceProgramViewFragment(this.listing, (DBTraceMemoryRegion)r))));
            Group[] groupArray = (Group[])frags.toArray(new DBTraceProgramViewFragment[frags.size()]);
            return groupArray;
        }
    }

    public int getIndex(String name) {
        ArrayList names = new ArrayList();
        try (LockHold hold = LockHold.lock((Lock)this.program.trace.getReadWriteLock().readLock());){
            this.program.memory.forVisibleRegions(region -> names.add(region.getName()));
        }
        return names.indexOf(name);
    }

    public void add(ProgramModule module) throws CircularDependencyException, DuplicateGroupException {
        throw new UnsupportedOperationException();
    }

    public void add(ProgramFragment fragment) throws DuplicateGroupException {
        throw new UnsupportedOperationException();
    }

    public ProgramModule createModule(String moduleName) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public ProgramFragment createFragment(String fragmentName) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public void reparent(String name, ProgramModule oldParent) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    public void moveChild(String name, int index) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean removeChild(String name) throws NotEmptyException {
        throw new UnsupportedOperationException();
    }

    public boolean isDescendant(ProgramModule module) {
        return false;
    }

    public boolean isDescendant(ProgramFragment fragment) {
        return true;
    }

    protected <T> T reduceRegions(final Function<TraceMemoryRegion, T> func, final BiFunction<T, T, T> reducer) {
        var action = new Consumer<TraceMemoryRegion>(){
            public T cur;

            @Override
            public void accept(TraceMemoryRegion region) {
                this.cur = this.cur == null ? func.apply(region) : reducer.apply(this.cur, func.apply(region));
            }
        };
        return action.cur;
    }

    public Address getMinAddress() {
        if (!this.program.viewport.isForked()) {
            return this.program.trace.getMemoryManager().getRegionsAddressSet(this.program.snap).getMinAddress();
        }
        return this.reduceRegions(TraceMemoryRegion::getMinAddress, ComparatorMath::cmin);
    }

    public Address getMaxAddress() {
        if (!this.program.viewport.isForked()) {
            return this.program.trace.getMemoryManager().getRegionsAddressSet(this.program.snap).getMaxAddress();
        }
        return this.reduceRegions(TraceMemoryRegion::getMaxAddress, ComparatorMath::cmax);
    }

    public Address getFirstAddress() {
        return this.getMinAddress();
    }

    public Address getLastAddress() {
        return this.getMaxAddress();
    }

    public AddressSetView getAddressSet() {
        return this.program.viewport.unionedAddresses(s -> this.program.trace.getMemoryManager().getRegionsAddressSet((long)s));
    }

    public Object getVersionTag() {
        return this.program.versionTag;
    }

    public long getModificationNumber() {
        return this.program.versionTag;
    }

    public long getTreeID() {
        return 0L;
    }
}

