/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.database.memory.DBTraceMemoryRegisterSpace;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemory;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewRegisterMemoryBlock;

public class DBTraceProgramViewRegisterMemory
extends AbstractDBTraceProgramViewMemory {
    protected final DBTraceMemoryRegisterSpace space;
    protected final DBTraceProgramViewRegisterMemoryBlock block;

    public DBTraceProgramViewRegisterMemory(DBTraceProgramView program, DBTraceMemoryRegisterSpace space) {
        super(program);
        this.space = space;
        this.block = new DBTraceProgramViewRegisterMemoryBlock(program, space);
        this.addressSet = new AddressSet((AddressRange)new AddressRangeImpl(space.getAddressSpace().getMinAddress(), space.getAddressSpace().getMaxAddress()));
    }

    @Override
    public void setForceFullView(boolean forceFullView) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void recomputeAddressSet() {
    }

    public MemoryBlock getBlock(Address addr) {
        if (addr.getAddressSpace().isRegisterSpace()) {
            return this.block;
        }
        return null;
    }

    public MemoryBlock getBlock(String blockName) {
        if ("regs".equals(blockName)) {
            return this.block;
        }
        return null;
    }

    public MemoryBlock[] getBlocks() {
        return new MemoryBlock[]{this.block};
    }
}

