/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.address;

import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.TraceAddressFactory;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceOverlaySpaceAdapter
implements DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceOverlaySpaceEntry> overlayStore;
    protected final DBCachedObjectIndex<String, DBTraceOverlaySpaceEntry> overlaysByName;
    private final Map<Long, AddressSpace> spacesByKey = new HashMap<Long, AddressSpace>();

    public DBTraceOverlaySpaceAdapter(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.overlayStore = factory.getOrCreateCachedStore("AddressSpaces", DBTraceOverlaySpaceEntry.class, DBTraceOverlaySpaceEntry::new, true);
        this.overlaysByName = this.overlayStore.getIndex(String.class, DBTraceOverlaySpaceEntry.NAME_COLUMN);
        this.resyncAddressFactory();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.overlayStore.invalidateCache();
            this.resyncAddressFactory();
        }
    }

    protected void resyncAddressFactory() {
        TraceAddressFactory factory = this.trace.getInternalAddressFactory();
        this.resyncAddressFactory(factory);
    }

    protected void resyncAddressFactory(TraceAddressFactory factory) {
        for (AddressSpace space : factory.getAllAddressSpaces()) {
            if (!(space instanceof OverlayAddressSpace)) continue;
            OverlayAddressSpace os = (OverlayAddressSpace)space;
            DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)this.overlayStore.getObjectAt(os.getDatabaseKey());
            if (ent == null) {
                this.spacesByKey.remove(os.getDatabaseKey());
                factory.removeOverlaySpace(os.getName());
                continue;
            }
            if (os.getName().equals(ent.name)) continue;
            factory.removeOverlaySpace(os.getName());
            os.setName(ent.name);
            try {
                factory.addOverlayAddressSpace(os);
            }
            catch (DuplicateNameException e) {
                throw new AssertionError();
            }
        }
        for (DBTraceOverlaySpaceEntry ent : this.overlayStore.asMap().values()) {
            AddressSpace exists = factory.getAddressSpace(ent.name);
            if (exists != null) continue;
            AddressSpace baseSpace = factory.getAddressSpace(ent.baseSpace);
            try {
                OverlayAddressSpace space = factory.addOverlayAddressSpace(ent.name, true, baseSpace, baseSpace.getMinAddress().getOffset(), baseSpace.getMaxAddress().getOffset());
                space.setDatabaseKey(ent.getKey());
                this.spacesByKey.put(space.getDatabaseKey(), (AddressSpace)space);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError();
            }
        }
    }

    public AddressSpace createOverlayAddressSpace(String name, AddressSpace base) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TraceAddressFactory factory = this.trace.getInternalAddressFactory();
            if (factory.getAddressSpace(name) != null) {
                throw new DuplicateNameException("Address space " + name + " already exists.");
            }
            OverlayAddressSpace space = factory.addOverlayAddressSpace(name, true, base, base.getMinAddress().getOffset(), base.getMaxAddress().getOffset());
            DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)this.overlayStore.create();
            ent.set(space.getName(), base.getName());
            this.trace.updateViewsAddSpaceBlock((AddressSpace)space);
            OverlayAddressSpace overlayAddressSpace = space;
            return overlayAddressSpace;
        }
    }

    public void deleteOverlayAddressSpace(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceOverlaySpaceEntry exists = (DBTraceOverlaySpaceEntry)this.overlaysByName.getOne((Object)name);
            if (exists == null) {
                throw new NoSuchElementException(name);
            }
            this.overlayStore.delete((DBAnnotatedObject)exists);
            TraceAddressFactory factory = this.trace.getInternalAddressFactory();
            AddressSpace space = factory.getAddressSpace(name);
            assert (space != null);
            factory.removeOverlaySpace(name);
            this.trace.updateViewsDeleteSpaceBlock(space);
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceOverlaySpaceEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "AddressSpaces";
        static final String NAME_COLUMN_NAME = "Name";
        static final String BASE_COLUMN_NAME = "Base";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedColumn(value="Base")
        static DBObjectColumn BASE_COLUMN;
        @DBAnnotatedField(column="Name", indexed=true)
        String name;
        @DBAnnotatedField(column="Base")
        String baseSpace;

        public DBTraceOverlaySpaceEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(String name, String baseSpace) {
            this.name = name;
            this.baseSpace = baseSpace;
            this.update(NAME_COLUMN, BASE_COLUMN);
        }
    }

    public static class AddressDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<Address, OT, BinaryField> {
        static final Charset UTF8 = Charset.forName("UTF-8");

        public AddressDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Address.class, objectType, BinaryField.class, field, column);
        }

        protected byte[] encode(Address address) {
            if (address == null) {
                return null;
            }
            AddressSpace as = address.getAddressSpace();
            ByteBuffer buf = ByteBuffer.allocate(11);
            if (as instanceof OverlayAddressSpace) {
                buf.put((byte)1);
                OverlayAddressSpace os = (OverlayAddressSpace)as;
                buf.putShort((short)os.getDatabaseKey());
            } else {
                buf.put((byte)0);
                buf.putShort((short)as.getSpaceID());
            }
            buf.putLong(address.getOffset());
            return buf.array();
        }

        public void store(Address value, BinaryField f) {
            f.setBinaryData(this.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, this.encode((Address)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte[] data = record.getBinaryData(this.column);
            if (data == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                AddressSpace as;
                ByteBuffer buf = ByteBuffer.wrap(data);
                byte overlay = buf.get();
                if (overlay == 1) {
                    short key = buf.getShort();
                    as = ((DecodesAddresses)obj).getOverlaySpaceAdapter().spacesByKey.get((long)key & 0xFFFFL);
                } else {
                    short id = buf.getShort();
                    as = ((DecodesAddresses)obj).getOverlaySpaceAdapter().trace.getInternalAddressFactory().getAddressSpace(id);
                }
                long offset = buf.getLong();
                this.setValue((DBAnnotatedObject)obj, as.getAddress(offset));
            }
        }
    }

    public static interface DecodesAddresses {
        public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter();
    }
}

