/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.Field;
import db.util.ErrorHandler;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBCachedObjectStoreFoundKeysValueCollection<T extends DBAnnotatedObject>
implements Collection<T> {
    protected final DBCachedObjectStore<T> store;
    protected final ErrorHandler errHandler;
    protected final ReadWriteLock lock;
    protected final Set<Long> keys;

    public DBCachedObjectStoreFoundKeysValueCollection(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, Field[] keys) {
        this.store = store;
        this.errHandler = errHandler;
        this.lock = lock;
        this.keys = Stream.of(keys).map(Field::getLongValue).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            DBAnnotatedObject t = (DBAnnotatedObject)((Object)this.store.objects.checkAndConvert(o));
            if (t == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.keys.contains(t.getKey())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.store.objects.typedContains(t);
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return false;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.keys.stream().map(this.store::getObjectAt).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.keys.size()];
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            int i = 0;
            for (long k : this.keys) {
                array[i++] = this.store.objects.get(k);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a.length < this.keys.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.keys.size());
        }
        int i = 0;
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            for (long k : this.keys) {
                a[i++] = this.store.objects.get(k);
            }
            while (i < a.length) {
                a[i++] = null;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            for (Object o : c) {
                DBAnnotatedObject t = (DBAnnotatedObject)((Object)this.store.objects.checkAndConvert(o));
                if (t == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.keys.contains(t.getKey())) {
                    boolean bl = false;
                    return bl;
                }
                if (this.store.objects.typedContains(t)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

