/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SleighExpression;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcodeCPort.slgh_compile.PcodeParser;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jdom.JDOMException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SleighProgramCompiler {
    private static final String EXPRESSION_SOURCE_NAME = "expression";

    public static PcodeParser createParser(SleighLanguage language) {
        String translatorTag = language.buildTranslatorTag(language.getAddressFactory(), language.getUniqueBase(), language.getSymbolTable());
        try {
            return new PcodeParser(translatorTag);
        }
        catch (JDOMException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ConstructTpl compileTemplate(Language language, PcodeParser parser, String sourceName, String text) {
        try {
            String templateXml = PcodeParser.stringifyTemplate((ghidra.pcodeCPort.semantics.ConstructTpl)Objects.requireNonNull(parser.compilePcode(text, EXPRESSION_SOURCE_NAME, 1)));
            MyErrorHandler eh = new MyErrorHandler();
            XmlPullParser xmlParser = XmlPullParserFactory.create((String)templateXml, (String)EXPRESSION_SOURCE_NAME, (ErrorHandler)eh, (boolean)false);
            ConstructTpl template = new ConstructTpl();
            template.restoreXml(xmlParser, language.getAddressFactory());
            return template;
        }
        catch (UnknownInstructionException | SAXException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<PcodeOp> buildOps(Language language, ConstructTpl template) throws UnknownInstructionException, MemoryAccessException {
        Address zero = language.getDefaultSpace().getAddress(0L);
        SleighParserContext c = new SleighParserContext(zero, zero, zero, zero);
        ParserWalker walk = new ParserWalker(c);
        PcodeEmitObjects emit = new PcodeEmitObjects(walk);
        emit.build(template, 0);
        emit.resolveRelatives();
        return List.of(emit.getPcodeOp());
    }

    protected static void addParserSymbols(PcodeParser parser, Map<Integer, UserOpSymbol> symbols) {
        for (UserOpSymbol sym : symbols.values()) {
            parser.addSymbol((SleighSymbol)sym);
        }
    }

    public static PcodeProgram compileProgram(SleighLanguage language, String sourceName, List<String> lines, SleighUseropLibrary<?> library) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = library.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, sourceName, StringUtils.join(lines, (String)"\n"));
        try {
            return new PcodeProgram(language, SleighProgramCompiler.buildOps((Language)language, template), symbols);
        }
        catch (UnknownInstructionException | MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SleighExpression compileExpression(SleighLanguage language, String expression) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = SleighExpression.CAPTURING.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, EXPRESSION_SOURCE_NAME, "___result(" + expression + ");");
        try {
            return new SleighExpression(language, SleighProgramCompiler.buildOps((Language)language, template), symbols);
        }
        catch (UnknownInstructionException | MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class MyErrorHandler
    implements ErrorHandler {
        SAXParseException exc;

        MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            Msg.warn((Object)this, (Object)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.exc = e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.exc = e;
        }
    }
}

