/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HTMLUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcodeProgram {
    protected final SleighLanguage language;
    protected final List<PcodeOp> code;
    protected final Map<Integer, String> useropNames = new HashMap<Integer, String>();

    protected static String htmlSpan(String cls, String display) {
        return String.format("<span class=\"%s\">%s</span>", cls, HTMLUtilities.escapeHTML((String)display));
    }

    public static String registerToString(Register reg, boolean markup) {
        if (markup) {
            return PcodeProgram.htmlSpan("register", reg.toString());
        }
        return reg.toString();
    }

    public static String constToString(Varnode cvn, boolean markup) {
        String display = String.format("%d:%d", cvn.getOffset(), cvn.getSize());
        if (markup) {
            return PcodeProgram.htmlSpan("constant", display);
        }
        return display;
    }

    public static String uniqueToString(Varnode uvn, boolean markup) {
        String display = String.format("$U%s:%d", uvn.getAddress().getOffsetAsBigInteger().toString(16), uvn.getSize());
        if (markup) {
            return PcodeProgram.htmlSpan("unique", display);
        }
        return display;
    }

    public static String addressToString(Varnode avn, boolean markup) {
        String display = String.format("%s:%d", avn.getAddress().toString(true), avn.getSize());
        if (markup) {
            return PcodeProgram.htmlSpan("address", display);
        }
        return display;
    }

    public static String vnToString(Language language, Varnode vn, boolean markup) {
        Register reg = language.getRegister(vn.getAddress().getAddressSpace(), vn.getOffset(), vn.getSize());
        if (reg != null) {
            return PcodeProgram.registerToString(reg, markup);
        }
        if (vn.isConstant()) {
            return PcodeProgram.constToString(vn, markup);
        }
        if (vn.isUnique()) {
            return PcodeProgram.uniqueToString(vn, markup);
        }
        return PcodeProgram.addressToString(vn, markup);
    }

    public static String spaceToString(Language language, Varnode vn, boolean markup) {
        String display;
        if (!vn.isConstant()) {
            throw new IllegalArgumentException("space id must be a constant varnode");
        }
        AddressSpace space = language.getAddressFactory().getAddressSpace((int)vn.getOffset());
        String string = display = space == null ? "<null>" : space.getName();
        if (markup) {
            return PcodeProgram.htmlSpan("space", display);
        }
        return display;
    }

    public static String useropToString(Language language, Varnode vn, boolean markup) {
        if (!vn.isConstant()) {
            throw new IllegalArgumentException("userop index must be a constant varnode");
        }
        String display = "\"" + language.getUserDefinedOpName((int)vn.getOffset()) + "\"";
        if (markup) {
            return PcodeProgram.htmlSpan("userop", display);
        }
        return display;
    }

    public static String opCodeToString(Language language, int op, boolean markup) {
        if (markup) {
            return PcodeProgram.htmlSpan("op", PcodeOp.getMnemonic((int)op));
        }
        return PcodeOp.getMnemonic((int)op);
    }

    public static String opToString(Language language, PcodeOp op, boolean markup) {
        int i;
        boolean isUserop;
        StringBuilder sb = new StringBuilder();
        Varnode output = op.getOutput();
        if (output != null) {
            sb.append(PcodeProgram.vnToString(language, output, markup));
            sb.append(" = ");
        }
        int opcode = op.getOpcode();
        sb.append(PcodeProgram.opCodeToString(language, opcode, markup));
        boolean isDeref = opcode == 2 || opcode == 3;
        boolean bl = isUserop = opcode == 9;
        if (isDeref) {
            sb.append(' ');
            sb.append(PcodeProgram.spaceToString(language, op.getInput(0), markup));
            sb.append('(');
            sb.append(PcodeProgram.vnToString(language, op.getInput(1), markup));
            sb.append(')');
            i = 2;
        } else if (isUserop) {
            sb.append(' ');
            sb.append(PcodeProgram.useropToString(language, op.getInput(0), markup));
            i = 1;
        } else {
            i = 0;
        }
        while (i < op.getNumInputs()) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(' ');
            sb.append(PcodeProgram.vnToString(language, op.getInput(i), markup));
            ++i;
        }
        return sb.toString();
    }

    public static PcodeProgram fromInstruction(Instruction instruction) {
        Language language = instruction.getPrototype().getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Instruction must be parsed using Sleigh");
        }
        PcodeOp[] pcode = instruction.getPcode(false);
        return new PcodeProgram((SleighLanguage)language, List.of(pcode), Map.of());
    }

    protected PcodeProgram(SleighLanguage language, List<PcodeOp> code, Map<Integer, UserOpSymbol> useropSymbols) {
        this.language = language;
        this.code = code;
        int langOpCount = language.getNumberOfUserDefinedOpNames();
        for (Map.Entry<Integer, UserOpSymbol> ent : useropSymbols.entrySet()) {
            int index = ent.getKey();
            if (index < langOpCount) {
                this.useropNames.put(index, language.getUserDefinedOpName(index));
                continue;
            }
            this.useropNames.put(index, ent.getValue().getName());
        }
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public <T> void execute(PcodeExecutor<T> executor, SleighUseropLibrary<T> library) {
        executor.execute(this, library);
    }

    protected String getHead() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<" + this.getHead() + ":");
        for (PcodeOp op : this.code) {
            sb.append("\n  " + op.getSeqnum() + ": " + PcodeProgram.opToString((Language)this.language, op, false));
        }
        sb.append("\n>");
        return sb.toString();
    }
}

