/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PublicSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.app.util.pdb.pdbapplicator.VbtManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdbVbtManager
extends VbtManager {
    private Map<String, Address> addressByMangledName;
    private Memory memory;

    private static Memory getMemory(PdbApplicator applicator) throws PdbException {
        Program program = applicator.getProgram();
        if (program == null) {
            throw new PdbException("Program null for VbtManager");
        }
        return program.getMemory();
    }

    private static Map<String, Address> findVirtualBaseTableSymbols(PdbApplicator applicator) throws CancelledException {
        TaskMonitor monitor = applicator.getMonitor();
        SymbolGroup symbolGroup = applicator.getSymbolGroup();
        HashMap<String, Address> myAddressByMangledName = new HashMap<String, Address>();
        PublicSymbolInformation publicSymbolInformation = applicator.getPdb().getDebugInfo().getPublicSymbolInformation();
        List<Long> offsets = publicSymbolInformation.getModifiedHashRecordSymbolOffsets();
        applicator.setMonitorMessage("PDB: Searching for virtual base table symbols...");
        monitor.initialize((long)offsets.size());
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        for (long offset : offsets) {
            Address address;
            AbstractPublicMsSymbol pubSymbol;
            String name;
            monitor.checkCanceled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            if (symbol instanceof AbstractPublicMsSymbol && (name = (pubSymbol = (AbstractPublicMsSymbol)symbol).getName()).startsWith("??_8") && !applicator.isInvalidAddress(address = applicator.getAddress(pubSymbol), name)) {
                myAddressByMangledName.put(name, address);
            }
            monitor.incrementProgress(1L);
        }
        return myAddressByMangledName;
    }

    PdbVbtManager(PdbApplicator applicator) throws PdbException, CancelledException {
        this(applicator.getDataTypeManager(), PdbVbtManager.getMemory(applicator), PdbVbtManager.findVirtualBaseTableSymbols(applicator));
    }

    PdbVbtManager(DataTypeManager dataTypeManager, Memory memory, Map<String, Address> addressByMangledName) {
        super(dataTypeManager);
        this.memory = memory;
        this.addressByMangledName = addressByMangledName;
    }

    PdbVirtualBaseTable createVirtualBaseTableByName(String mangledName, int entrySize) {
        Address address = this.addressByMangledName.get(mangledName);
        if (address == null) {
            return null;
        }
        return this.createVirtualBaseTable(address, entrySize);
    }

    PdbVirtualBaseTable createVirtualBaseTable(Address address, int entrySize) {
        VbtManager.VirtualBaseTable vbt = (VbtManager.VirtualBaseTable)this.vbtByAddress.get(address);
        if (vbt != null) {
            String message = "PDB: warning virtual base table already exists for address: " + address;
            PdbLog.message(message);
            Msg.info((Object)this, (Object)message);
        } else {
            vbt = new PdbVirtualBaseTable(this.memory, address, entrySize);
            this.vbtByAddress.put(address, vbt);
        }
        if (!(vbt instanceof PdbVirtualBaseTable)) {
            // empty if block
        }
        return (PdbVirtualBaseTable)vbt;
    }

    long getOffset(String vbtMangledName, int ordinal, int size) throws PdbException {
        Address address = this.addressByMangledName.get(vbtMangledName);
        if (address == null) {
            throw new PdbException("Virtual Base Table does not exist for symbol: " + vbtMangledName);
        }
        return this.getOffset(address, ordinal, size);
    }

    long getOffset(Address address, int ordinal, int size) throws PdbException {
        VbtManager.VirtualBaseTable table = (VbtManager.VirtualBaseTable)this.vbtByAddress.get(address);
        if (table == null) {
            throw new PdbException("Virtual Base Table does not exist for address: " + address);
        }
        if (!(table instanceof PdbVirtualBaseTable)) {
            throw new PdbException("Not a PDB Virtual Base Table for address: " + address);
        }
        VbtManager.VirtualBaseTableEntry entry = ((PdbVirtualBaseTable)table).getOrParseEntryByOrdinal(ordinal);
        return entry.getOffset();
    }

    private void createVirtualBaseTables() {
        for (Map.Entry<String, Address> entry : this.addressByMangledName.entrySet()) {
            Address address = entry.getValue();
            this.createVirtualBaseTable(address);
        }
    }

    static VbtManager.VirtualBaseTableEntry parseVbtEntryFromMemory(Memory memory, Address address, int ordinal, int size) throws PdbException {
        long offset;
        if (size != 4 && size != 8) {
            throw new IllegalArgumentException("Invalid size (" + size + "): must be 4 or 8.");
        }
        Address readAddress = address.add((long)(ordinal * size));
        try {
            offset = size == 4 ? (long)memory.getInt(readAddress) : memory.getLong(readAddress);
        }
        catch (MemoryAccessException e) {
            throw new PdbException("MemoryAccessException while trying to parse virtual base table entry at address: " + readAddress);
        }
        return new VbtManager.VirtualBaseTableEntry(offset);
    }

    static class PdbVirtualBaseTable
    extends VbtManager.VirtualBaseTable {
        private Memory memory;
        private Address address;
        private int entrySize;

        PdbVirtualBaseTable(Memory memory, Address address, int entrySize) {
            this.memory = memory;
            this.address = address;
            this.entrySize = entrySize;
        }

        @Override
        VbtManager.VirtualBaseTableEntry getEntry(int ordinal) throws PdbException {
            return this.getOrParseEntryByOrdinal(ordinal);
        }

        VbtManager.VirtualBaseTableEntry getOrParseEntryByOrdinal(int ordinal) throws PdbException {
            VbtManager.VirtualBaseTableEntry entry = (VbtManager.VirtualBaseTableEntry)this.entryByOrdinal.get(ordinal);
            if (entry == null) {
                entry = PdbVbtManager.parseVbtEntryFromMemory(this.memory, this.address, ordinal, this.entrySize);
                this.addEntry(ordinal, entry);
            }
            return entry;
        }
    }
}

