/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import docking.widgets.table.RowWrappedEnumeratedColumnTableModel;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.util.Swing;
import java.util.function.Function;

public class DebouncedRowWrappedEnumeratedColumnTableModel<C extends Enum<C>, K, R, T>
extends RowWrappedEnumeratedColumnTableModel<C, K, R, T> {
    AsyncDebouncer<Void> debouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);

    public DebouncedRowWrappedEnumeratedColumnTableModel(String name, Class<C> colType, Function<T, K> keyFunc, Function<T, R> wrapper) {
        super(name, colType, keyFunc, wrapper);
        this.debouncer.addListener(this::settled);
    }

    public void fireTableDataChanged() {
        this.debouncer.contact(null);
    }

    public void fireTableCellUpdated(int row, int column) {
        this.debouncer.contact(null);
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.debouncer.contact(null);
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.debouncer.contact(null);
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.debouncer.contact(null);
    }

    private void settled(Void __) {
        Swing.runLater(() -> super.fireTableDataChanged());
    }
}

