/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.launch;

import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServicePlugin;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.services.DebuggerModelService;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractDebuggerProgramLaunchOffer
implements DebuggerProgramLaunchOffer {
    protected final Program program;
    protected final PluginTool tool;
    protected final DebuggerModelFactory factory;

    public AbstractDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
        this.program = program;
        this.tool = tool;
        this.factory = factory;
    }

    @Override
    public String getMenuParentTitle() {
        String name = this.program.getName();
        DomainFile df = this.program.getDomainFile();
        if (df != null) {
            name = df.getName();
        }
        return "Debug " + name;
    }

    protected List<String> getLauncherPath() {
        return PathUtils.parse((String)"");
    }

    private void saveLauncherArgs(Map<String, ?> args, Map<String, TargetMethod.ParameterDescription<?>> params) {
        SaveState state = new SaveState();
        for (TargetMethod.ParameterDescription<?> param : params.values()) {
            Object val = args.get(param.name);
            if (val == null) continue;
            AutoConfigState.ConfigStateField.putState((SaveState)state, param.type.asSubclass(Object.class), (String)param.name, val);
        }
        String owner = PluginUtils.getPluginNameFromClass(DebuggerModelServicePlugin.class);
        ProgramUserData userData = this.program.getProgramUserData();
        try (UndoableTransaction tid = UndoableTransaction.start((ProgramUserData)userData);){
            StringPropertyMap stringProperty = userData.getStringProperty(owner, this.getConfigName(), true);
            Element element = state.saveToXml();
            stringProperty.add(Address.NO_ADDRESS, XmlUtilities.toString((Element)element));
        }
    }

    protected Map<String, ?> takeDefaultsForParameters(Map<String, TargetMethod.ParameterDescription<?>> params) {
        return params.values().stream().collect(Collectors.toMap(p -> p.name, p -> p.defaultValue));
    }

    protected abstract Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> var1);

    protected Map<String, ?> promptLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
        DebuggerMethodInvocationDialog dialog = new DebuggerMethodInvocationDialog(this.tool, this.getButtonTitle(), "Launch", this.getIcon());
        Map<String, ?> args = this.loadLastLauncherArgs(params, true);
        for (TargetMethod.ParameterDescription<?> param : params.values()) {
            Object val = args.get(param.name);
            if (val == null) continue;
            dialog.setMemorizedArgument(param.name, param.type.asSubclass(Object.class), val);
        }
        args = dialog.promptArguments(params);
        if (args == null) {
            return null;
        }
        this.saveLauncherArgs(args, params);
        return args;
    }

    protected Map<String, ?> loadLastLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params, boolean forPrompt) {
        String xml;
        String owner = PluginUtils.getPluginNameFromClass(DebuggerModelServicePlugin.class);
        ProgramUserData userData = this.program.getProgramUserData();
        StringPropertyMap property = userData.getStringProperty(owner, this.getConfigName(), false);
        if (property != null && (xml = property.getString(Address.NO_ADDRESS)) != null) {
            try {
                Element element = XmlUtilities.fromString((String)xml);
                SaveState state = new SaveState(element);
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                for (TargetMethod.ParameterDescription<?> param : params.values()) {
                    args.put(param.name, AutoConfigState.ConfigStateField.getState((SaveState)state, (Class)param.type, (String)param.name));
                }
                return args;
            }
            catch (IOException | JDOMException e) {
                if (!forPrompt) {
                    throw new RuntimeException("Saved launcher args are corrupt, or launcher parameters changed. Not launching.", e);
                }
                Msg.error((Object)this, (Object)"Saved launcher args are corrup, or launcher parameters changed. Defaulting.", (Throwable)e);
            }
        }
        Map<String, ?> args = this.generateDefaultLauncherArgs(params);
        this.saveLauncherArgs(args, params);
        return args;
    }

    protected Map<String, ?> getLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params, boolean prompt) {
        return prompt ? this.promptLauncherArgs(params) : this.loadLastLauncherArgs(params, false);
    }

    protected DebuggerModelFactory getModelFactory() {
        return this.factory;
    }

    protected CompletableFuture<DebuggerObjectModel> connect(boolean prompt) {
        DebuggerModelService service = (DebuggerModelService)this.tool.getService(DebuggerModelService.class);
        DebuggerModelFactory factory = this.getModelFactory();
        if (prompt) {
            return service.showConnectDialog(factory);
        }
        return factory.build().thenApplyAsync(m -> {
            service.addModel((DebuggerObjectModel)m);
            return m;
        });
    }

    @Override
    public CompletableFuture<Void> launchProgram(TaskMonitor monitor, boolean prompt) {
        monitor.initialize(2L);
        monitor.setMessage("Connecting");
        return ((CompletableFuture)((CompletableFuture)this.connect(prompt).thenComposeAsync(m -> {
            List<String> launcherPath = this.getLauncherPath();
            TargetObjectSchema schema = m.getRootSchema().getSuccessorSchema(launcherPath);
            if (!schema.getInterfaces().contains(TargetLauncher.class)) {
                throw new AssertionError((Object)"LaunchOffer / model implementation error: The given launcher path is not a TargetLauncher, according to its schema");
            }
            return new ValueExpecter((DebuggerObjectModel)m, launcherPath);
        }, (Executor)SwingExecutorService.INSTANCE)).thenCompose(l -> {
            monitor.incrementProgress(1L);
            monitor.setMessage("Launching");
            TargetLauncher launcher = (TargetLauncher)l;
            Map<String, ?> args = this.getLauncherArgs((Map<String, TargetMethod.ParameterDescription<?>>)launcher.getParameters(), prompt);
            if (args == null) {
                return AsyncUtils.NIL;
            }
            return launcher.launch(args);
        })).thenRun(() -> monitor.incrementProgress(1L));
    }

    static class ValueExpecter
    extends CompletableFuture<Object>
    implements DebuggerModelListener {
        private final DebuggerObjectModel model;
        private final List<String> path;

        public ValueExpecter(DebuggerObjectModel model, List<String> path) {
            this.model = model;
            this.path = path;
            model.addModelListener((DebuggerModelListener)this);
            this.retryFetch();
        }

        protected void retryFetch() {
            ((CompletableFuture)this.model.fetchModelValue(this.path).thenAccept((T v) -> {
                if (v != null) {
                    this.model.removeModelListener((DebuggerModelListener)this);
                    this.complete(v);
                }
            })).exceptionally((T ex) -> {
                this.model.removeModelListener((DebuggerModelListener)this);
                this.completeExceptionally((Throwable)ex);
                return null;
            });
        }

        public void rootAdded(TargetObject root) {
            this.retryFetch();
        }

        public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
            this.retryFetch();
        }

        public void elementsChanged(TargetObject object, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            this.retryFetch();
        }
    }
}

