/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.app.plugin.core.debug.utils.DefaultTransactionCoalescer;
import ghidra.app.plugin.core.debug.utils.TransactionCoalescer;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.util.Msg;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class PermanentTransactionExecutor {
    private final TransactionCoalescer txc;
    private final Executor[] threads;
    private final UndoableDomainObject obj;

    public PermanentTransactionExecutor(UndoableDomainObject obj, String name, int threadCount, int delayMs) {
        this.obj = obj;
        this.txc = new DefaultTransactionCoalescer(obj, RecorderPermanentTransaction::start, delayMs);
        this.threads = new Executor[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name + "thread-" + i + "-%d").build();
            this.threads[i] = Executors.newSingleThreadExecutor((ThreadFactory)factory);
        }
    }

    protected Executor selectThread(Object sel) {
        if (sel == null) {
            return this.threads[0];
        }
        int h = sel.hashCode();
        return this.threads[Integer.remainderUnsigned(h ^ h >>> 16, this.threads.length)];
    }

    public CompletableFuture<Void> execute(String description, Runnable runnable, Object sel) {
        return CompletableFuture.runAsync(() -> {
            if (this.obj.isClosed()) {
                return;
            }
            try (TransactionCoalescer.CoalescedTx tx = this.txc.start(description);){
                runnable.run();
            }
        }, this.selectThread(sel)).exceptionally(e -> {
            Msg.error((Object)this, (Object)("Trouble recording " + description), (Throwable)e);
            return null;
        });
    }

    public CompletableFuture<Void> flush() {
        Runnable nop = () -> {};
        return CompletableFuture.allOf((CompletableFuture[])Stream.of(this.threads).map(t -> CompletableFuture.runAsync(nop, t)).toArray(CompletableFuture[]::new));
    }
}

