/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class LoneLogicalBreakpoint
implements LogicalBreakpointInternal {
    private final Set<Trace> justThisTrace;
    private final LogicalBreakpointInternal.TraceBreakpointSet breaks;
    private final long length;
    private final Set<TraceBreakpointKind> kinds;

    public LoneLogicalBreakpoint(TraceRecorder recorder, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        this.breaks = new LogicalBreakpointInternal.TraceBreakpointSet(recorder, address);
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.justThisTrace = Set.of(recorder.getTrace());
    }

    public String toString() {
        return String.format("<%s trace=%s>", this.getClass().getSimpleName(), this.breaks);
    }

    @Override
    public boolean isEmpty() {
        return this.breaks.isEmpty();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Set<TraceBreakpointKind> getKinds() {
        return this.kinds;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public Bookmark getProgramBookmark() {
        return null;
    }

    @Override
    public void setTraceAddress(TraceRecorder recorder, Address address) {
        throw new AssertionError();
    }

    @Override
    public Set<TraceBreakpoint> getTraceBreakpoints() {
        return new HashSet<TraceBreakpoint>(this.breaks.getBreakpoints());
    }

    @Override
    public Set<TraceBreakpoint> getTraceBreakpoints(Trace trace) {
        return this.breaks.getTrace() != trace ? Set.of() : this.getTraceBreakpoints();
    }

    @Override
    public Set<Trace> getMappedTraces() {
        return this.justThisTrace;
    }

    @Override
    public Set<Trace> getParticipatingTraces() {
        if (this.breaks.isEmpty()) {
            return Set.of();
        }
        return this.justThisTrace;
    }

    @Override
    public Address getTraceAddress(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return null;
        }
        return this.breaks.getAddress();
    }

    @Override
    public DomainObject getDomainObject() {
        return this.breaks.getTrace();
    }

    @Override
    public Address getAddress() {
        return this.breaks.getAddress();
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablementForProgram(Program program) {
        return LogicalBreakpoint.Enablement.NONE;
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablementForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return LogicalBreakpoint.Enablement.NONE;
        }
        return LogicalBreakpoint.ProgramEnablement.NONE.combineTrace(this.breaks.computeEnablement());
    }

    @Override
    public LogicalBreakpoint.Enablement computeEnablement() {
        return LogicalBreakpoint.ProgramEnablement.NONE.combineTrace(this.breaks.computeEnablement());
    }

    @Override
    public void enableForProgram() {
    }

    @Override
    public void disableForProgram() {
    }

    @Override
    public void deleteForProgram() {
    }

    @Override
    public CompletableFuture<Void> enableForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.NIL;
        }
        return this.enable();
    }

    @Override
    public CompletableFuture<Void> disableForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.NIL;
        }
        return this.disable();
    }

    @Override
    public CompletableFuture<Void> deleteForTrace(Trace trace) {
        if (trace != this.breaks.getTrace()) {
            return AsyncUtils.NIL;
        }
        return this.delete();
    }

    @Override
    public void planEnable(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planEnable(actions, this.length, this.kinds);
    }

    @Override
    public CompletableFuture<Void> enable() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planEnable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDisable(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planDisable(actions, this.length, this.kinds);
    }

    @Override
    public CompletableFuture<Void> disable() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDisable(actions, null);
        return actions.execute();
    }

    @Override
    public void planDelete(BreakpointActionSet actions, Trace trace) {
        if (trace != null && trace != this.breaks.getTrace()) {
            return;
        }
        this.breaks.planDelete(actions, this.length, this.kinds);
    }

    @Override
    public CompletableFuture<Void> delete() {
        BreakpointActionSet actions = new BreakpointActionSet();
        this.planDelete(actions, null);
        return actions.execute();
    }

    @Override
    public boolean canMerge(Program program, Bookmark bookmark) {
        return false;
    }

    @Override
    public boolean canMerge(TraceBreakpoint breakpoint) {
        if (!Objects.equals(this.kinds, breakpoint.getKinds())) {
            return false;
        }
        return this.breaks.canMerge(breakpoint);
    }

    @Override
    public boolean trackBreakpoint(Bookmark bookmark) {
        throw new AssertionError();
    }

    @Override
    public boolean trackBreakpoint(TraceBreakpoint breakpoint) {
        return this.breaks.add(breakpoint);
    }

    @Override
    public boolean untrackBreakpoint(Program program, Bookmark bookmark) {
        return false;
    }

    @Override
    public boolean untrackBreakpoint(TraceBreakpoint breakpoint) {
        return this.breaks.remove(breakpoint);
    }
}

