/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableBreakpointActionItem;
import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetTogglable;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;

public class BreakpointActionSet
extends LinkedHashSet<BreakpointActionItem> {
    public EnableBreakpointActionItem planEnable(TargetBreakpointLocation loc) {
        if (loc instanceof TargetTogglable) {
            EnableBreakpointActionItem action = new EnableBreakpointActionItem((TargetTogglable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            EnableBreakpointActionItem action = new EnableBreakpointActionItem((TargetTogglable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public DisableBreakpointActionItem planDisable(TargetBreakpointLocation loc) {
        if (loc instanceof TargetTogglable) {
            DisableBreakpointActionItem action = new DisableBreakpointActionItem((TargetTogglable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            DisableBreakpointActionItem action = new DisableBreakpointActionItem((TargetTogglable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public DeleteBreakpointActionItem planDelete(TargetBreakpointLocation loc) {
        if (loc instanceof TargetDeletable) {
            DeleteBreakpointActionItem action = new DeleteBreakpointActionItem((TargetDeletable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            DeleteBreakpointActionItem action = new DeleteBreakpointActionItem((TargetDeletable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public CompletableFuture<Void> execute() {
        AsyncFence fence = new AsyncFence();
        for (BreakpointActionItem item : this) {
            fence.include(item.execute());
        }
        return fence.ready();
    }
}

