/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.gui.memview.MemviewBoxType;
import ghidra.app.plugin.core.debug.gui.memview.MemviewMap;
import ghidra.program.model.address.AddressRange;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;

public class MemoryBox {
    protected String id;
    protected MemviewBoxType type;
    protected AddressRange range;
    protected long start;
    protected long stop = Long.MAX_VALUE;
    protected long startAddr;
    protected long stopAddr = -1L;
    protected long startTime;
    protected long stopTime = -1L;
    protected Color color = Color.BLUE;
    protected int pixAstart;
    protected int pixAend;
    protected int boundA;
    protected int pixTstart;
    protected int pixTend;
    protected int boundT;
    protected boolean current;

    public MemoryBox(String id, MemviewBoxType type, AddressRange range, long tick) {
        this.id = id;
        this.type = type;
        this.range = range;
        this.start = tick;
        this.color = type.getColor();
    }

    public MemoryBox(String id, MemviewBoxType type, AddressRange range, Range<Long> trange) {
        this(id, type, range, (Long)trange.lowerEndpoint());
        if (trange.hasUpperBound()) {
            this.setEnd((Long)trange.upperEndpoint());
        }
    }

    public String getId() {
        return this.id;
    }

    public MemviewBoxType getType() {
        return this.type;
    }

    public AddressRange getRange() {
        return this.range;
    }

    public Range<Long> getSpan() {
        return Range.openClosed((Comparable)Long.valueOf(this.start), (Comparable)Long.valueOf(this.stop));
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.stop;
    }

    public void setEnd(long tick) {
        this.stop = this.stop < tick ? this.stop : tick;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(Color base, int type) {
        this.setColor(new Color(base.getRed(), (base.getGreen() + type) % 255, base.getBlue()));
    }

    public void setColor(Color base, int type, int src) {
        this.setColor(new Color(base.getRed(), (base.getGreen() + type * 8) % 255, (base.getBlue() + src * 16) % 255));
    }

    public int getAddressPixelStart() {
        return this.pixAstart;
    }

    public int getAddressPixelWidth() {
        if (this.pixAend - this.pixAstart <= 0) {
            return 1;
        }
        return this.pixAend - this.pixAstart;
    }

    public int getTimePixelStart() {
        return this.pixTstart;
    }

    public int getTimePixelWidth() {
        if (this.pixTend < this.pixTstart) {
            this.pixTend = this.boundT;
        }
        if (this.pixTend - this.pixTstart == 0) {
            return 1;
        }
        return this.pixTend - this.pixTstart;
    }

    public int getX(boolean vertical) {
        return vertical ? this.pixTstart : this.pixAstart;
    }

    public int getY(boolean vertical) {
        return vertical ? this.pixAstart : this.pixTstart;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void render(Graphics g, boolean vertical) {
        int x = vertical ? this.getTimePixelStart() : this.getAddressPixelStart();
        int w = vertical ? this.getTimePixelWidth() : this.getAddressPixelWidth();
        int y = vertical ? this.getAddressPixelStart() : this.getTimePixelStart();
        int h = vertical ? this.getAddressPixelWidth() : this.getTimePixelWidth();
        g.setColor(Color.BLACK);
        g.fillRect(x - 1, y - 1, w + 2, h + 2);
        g.setColor(this.color);
        g.fillRect(x, y, w, h);
    }

    public void renderBA(Graphics g, boolean vertical, int sz) {
        int x = vertical ? 0 : this.getAddressPixelStart();
        int w = vertical ? sz : this.getAddressPixelWidth();
        int y = vertical ? this.getAddressPixelStart() : 0;
        int h = vertical ? this.getAddressPixelWidth() : sz;
        g.setColor(Color.BLACK);
        g.fillRect(x - 1, y - 1, w + 2, h + 2);
        g.setColor(this.color);
        g.fillRect(x, y, w, h);
    }

    public void renderBT(Graphics g, boolean vertical, int sz, int bound) {
        int x = vertical ? this.getTimePixelStart() : 0;
        int w = vertical ? 1 : sz;
        int y = vertical ? 0 : this.getTimePixelStart();
        int h = vertical ? sz : 1;
        g.setColor(Color.BLACK);
        g.fillRect(x - 1, y - 1, w + 2, h + 2);
        g.setColor(this.color);
        g.fillRect(x, y, w, h);
    }

    public void setAddressBounds(MemviewMap map, int bound) {
        if (this.stopAddr < 0L) {
            this.stopAddr = this.startAddr;
        }
        this.pixAstart = this.getPixel(map, this.startAddr, bound);
        this.pixAend = this.getPixel(map, this.stopAddr, bound);
        this.boundA = bound;
    }

    public void setTimeBounds(MemviewMap map, int bound) {
        this.pixTstart = this.getPixel(map, this.startTime, bound);
        this.pixTend = this.getPixel(map, this.stopTime, bound);
        this.boundT = bound;
    }

    protected int getPixel(MemviewMap map, long offset, int bound) {
        return map.getPixel(offset);
    }

    public long getStartAddress() {
        return this.startAddr;
    }

    public void setStartAddress(long val) {
        this.startAddr = val;
    }

    public long getStopAddress() {
        return this.stopAddr;
    }

    public void setStopAddress(long val) {
        this.stopAddr = val;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long val) {
        this.startTime = val;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long val) {
        this.stopTime = val;
    }

    public boolean inPixelRange(long pos) {
        if (pos < (long)this.pixTstart) {
            return false;
        }
        if (this.pixTend <= 0) {
            return true;
        }
        return pos <= (long)this.pixTend;
    }

    public Map<String, Object> getAttributeMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", this.getId());
        map.put("StartAddr", this.getStartAddress());
        map.put("StopAddr", this.getStopAddress());
        map.put("StartTime", this.getStartTime());
        map.put("StopTIme", this.getStopTime());
        return map;
    }
}

