/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public abstract class SymbolEntry {
    protected HighSymbol symbol;
    protected Address pcaddr;

    public SymbolEntry(HighSymbol sym) {
        this.symbol = sym;
    }

    public abstract void restoreXML(XmlPullParser var1) throws PcodeXMLException;

    public abstract void saveXml(StringBuilder var1);

    public abstract VariableStorage getStorage();

    public abstract int getSize();

    public abstract boolean isReadOnly();

    public abstract boolean isVolatile();

    public Address getPCAdress() {
        return this.pcaddr;
    }

    protected void parseRangeList(XmlPullParser parser) {
        XmlElement rangelistel = parser.start(new String[]{"rangelist"});
        if (parser.peek().isStart()) {
            XmlElement rangeel = parser.start(new String[]{"range"});
            String spc = rangeel.getAttribute("space");
            long offset = SpecXmlUtils.decodeLong((String)rangeel.getAttribute("first"));
            this.pcaddr = this.symbol.function.getAddressFactory().getAddressSpace(spc).getAddress(offset);
            this.pcaddr = this.symbol.function.getFunction().getEntryPoint().getAddressSpace().getOverlayAddress(this.pcaddr);
            parser.end(rangeel);
        }
        parser.end(rangelistel);
    }

    protected void buildRangelistXML(StringBuilder res) {
        long off;
        if (this.pcaddr == null || this.pcaddr.isExternalAddress()) {
            res.append("<rangelist/>");
            return;
        }
        res.append("<rangelist>");
        AddressSpace space = this.pcaddr.getAddressSpace();
        if (space.isOverlaySpace()) {
            space = space.getPhysicalSpace();
            off = space.getAddress(this.pcaddr.getOffset()).getUnsignedOffset();
        } else {
            off = this.pcaddr.getUnsignedOffset();
        }
        res.append("<range");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"space", (String)space.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)res, (String)"first", (long)off);
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)res, (String)"last", (long)off);
        res.append("/>");
        res.append("</rangelist>\n");
    }
}

