/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import generic.stl.ComparableMapSTL;
import generic.stl.MapSTL;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.program.model.address.AddressSpace;

public class UniqueMemoryBank
extends MemoryBank {
    protected MapSTL<Long, WordInfo> map = new ComparableMapSTL();
    private static final long ALIGNMENT_MASK = -8L;
    private static final int WORD_SIZE = 8;
    private byte[] buffer = new byte[8];

    public UniqueMemoryBank(AddressSpace spc, boolean isBigEndian) {
        super(spc, isBigEndian, 0, null);
    }

    @Override
    protected MemoryPage getPage(long addr) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    protected void setPage(long addr, byte[] val, int skip, int size, int bufOffset) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    protected void setPageInitialized(long addr, boolean initialized, int skip, int size, int bufOffset) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    public int getChunk(long offset, int size, byte[] dest, boolean stopOnUninitialized) {
        int bytesRead = 0;
        if (size == 0) {
            return bytesRead;
        }
        try {
            WordInfo word;
            int adjustment = (int)offset % 8;
            if (adjustment != 0) {
                word = (WordInfo)this.map.get((Object)(offset & 0xFFFFFFFFFFFFFFF8L));
                if (word == null) {
                    throw new LowlevelError("Attempted to read uninitialized word in unique space");
                }
                for (int i = adjustment; i < 8 && bytesRead < size; ++i) {
                    dest[bytesRead++] = word.getByte(i);
                    ++offset;
                }
            }
            while (size - bytesRead > 0) {
                word = (WordInfo)this.map.get((Object)(offset & 0xFFFFFFFFFFFFFFF8L));
                if (word == null) {
                    throw new LowlevelError("Attempted to read uninitialized word in unique space");
                }
                offset += 8L;
                int bytesToRead = Math.min(8, size - bytesRead);
                if (word.isEntireWordInitialized()) {
                    word.getWord(this.buffer);
                    System.arraycopy(this.buffer, 0, dest, bytesRead, Math.min(8, size - bytesRead));
                    bytesRead += bytesToRead;
                    continue;
                }
                int base = bytesRead;
                for (int i = 0; i < bytesToRead; ++i) {
                    dest[base + i] = word.getByte(i);
                    ++bytesRead;
                }
            }
            return bytesRead;
        }
        catch (LowlevelError e) {
            if (stopOnUninitialized) {
                return bytesRead;
            }
            throw e;
        }
    }

    @Override
    public void setChunk(long offset, int size, byte[] src) {
        WordInfo word;
        if (size == 0 || src.length == 0) {
            return;
        }
        int currentPosition = 0;
        int adjustment = (int)offset % 8;
        if (adjustment != 0) {
            word = (WordInfo)this.map.get((Object)(offset & 0xFFFFFFFFFFFFFFF8L));
            if (word == null) {
                word = new WordInfo();
                this.map.put((Object)(offset & 0xFFFFFFFFFFFFFFF8L), (Object)word);
            }
            for (int i = adjustment; i < 8; ++i) {
                word.setByte(src[currentPosition], i);
                ++offset;
                ++currentPosition;
            }
        }
        while (size > currentPosition) {
            word = (WordInfo)this.map.get((Object)(offset & 0xFFFFFFFFFFFFFFF8L));
            if (word == null) {
                word = new WordInfo();
                this.map.put((Object)(offset & 0xFFFFFFFFFFFFFFF8L), (Object)word);
            }
            int bytesToWrite = Math.min(8, size - currentPosition);
            for (int i = 0; i < bytesToWrite; ++i) {
                word.setByte(src[currentPosition + i], i);
            }
            offset += (long)bytesToWrite;
            currentPosition += bytesToWrite;
        }
    }

    public void clear() {
        this.map.clear();
    }

    public static class WordInfo {
        public byte initialized = 0;
        public long word = 0L;

        public void setByte(byte val, int index) {
            this.validateIndex(index);
            this.word &= 255L << 8 * index ^ 0xFFFFFFFFFFFFFFFFL;
            long shifted = (long)val << 8 * index;
            this.word |= shifted;
            this.initialized = (byte)(this.initialized | 1 << index);
        }

        public byte getByte(int index) {
            this.validateIndex(index);
            this.checkInitialized(index);
            long selected = this.word & 255L << 8 * index;
            long adjusted = selected >> 8 * index;
            return (byte)adjusted;
        }

        public void getWord(byte[] buffer) {
            if (this.initialized != -1) {
                throw new LowlevelError("Attempted to read uninitialized word in unique space");
            }
            if (buffer.length != 8) {
                throw new IllegalArgumentException("Buffer must have length 8");
            }
            for (int i = 0; i < 8; ++i) {
                buffer[i] = (byte)((this.word & 255L << 8 * i) >> 8 * i);
            }
        }

        protected boolean isEntireWordInitialized() {
            return this.initialized == -1;
        }

        private void checkInitialized(int index) {
            if ((this.initialized & 1 << index) == 0) {
                throw new LowlevelError("Attempted to read uninitialized memory in the unique space.");
            }
        }

        private void validateIndex(int index) {
            if (index < 0 || index > 7) {
                throw new LowlevelError("Invalid index: " + Integer.toString(index));
            }
        }
    }
}

