/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ConstantValue
extends PatternValue {
    private long val;

    public int hashCode() {
        return Long.hashCode(this.val);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantValue)) {
            return false;
        }
        ConstantValue that = (ConstantValue)obj;
        return this.val == that.val;
    }

    public ConstantValue() {
        this.val = 0L;
    }

    public ConstantValue(long b) {
        this.val = b;
    }

    @Override
    public long minValue() {
        return this.val;
    }

    @Override
    public long maxValue() {
        return this.val;
    }

    @Override
    public long getValue(ParserWalker walker) throws MemoryAccessException {
        return this.val;
    }

    public long getValue() {
        return this.val;
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        XmlElement el = parser.start(new String[]{"intb"});
        this.val = SpecXmlUtils.decodeLong((String)el.getAttribute("val"));
        parser.end(el);
    }

    @Override
    public String toString() {
        return "0x" + Long.toHexString(this.val);
    }
}

