/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;

public class AssemblyResolvedBackfill
extends AssemblyResolution {
    protected final PatternExpression exp;
    protected final MaskedLong goal;
    protected final Map<Integer, Object> res;
    protected final int inslen;
    protected final int offset;

    @Override
    protected int computeHash() {
        int result = 0;
        result += this.exp.hashCode();
        result *= 31;
        result += this.goal.hashCode();
        result *= 31;
        result += this.inslen;
        result *= 31;
        return result += this.offset;
    }

    AssemblyResolvedBackfill(String description, PatternExpression exp, MaskedLong goal, Map<Integer, Object> res, int inslen, int offset) {
        super(description, null);
        this.exp = exp;
        this.goal = goal;
        this.res = res;
        this.inslen = inslen;
        this.offset = offset;
    }

    AssemblyResolvedBackfill copy() {
        AssemblyResolvedBackfill cp = new AssemblyResolvedBackfill(this.description, this.exp, this.goal, this.res, this.inslen, this.offset);
        return cp;
    }

    public int getInstructionLength() {
        return this.offset + this.inslen;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isBackfill() {
        return true;
    }

    @Override
    protected String lineToString() {
        return "Backfill (len:" + this.inslen + ",off:" + this.offset + ") " + this.goal + " := " + this.exp + " (" + this.description + ")";
    }

    public AssemblyResolvedBackfill shift(int amt) {
        return new AssemblyResolvedBackfill(this.description, this.exp, this.goal, this.res, this.inslen, this.offset + amt);
    }

    public AssemblyResolution solve(RecursiveDescentSolver solver, Map<String, Long> vals, AssemblyResolvedConstructor cur) {
        try {
            AssemblyResolution ar = solver.solve(this.exp, this.goal, vals, this.res, cur.truncate(this.offset), this.description);
            if (ar.isError()) {
                return ar;
            }
            AssemblyResolvedConstructor rc = (AssemblyResolvedConstructor)ar;
            return rc.shift(this.offset);
        }
        catch (NeedsBackfillException e) {
            return AssemblyResolution.error("Solution still requires backfill", this.description, null);
        }
        catch (UnsupportedOperationException e) {
            return AssemblyResolution.error("Unsupported: " + e.getMessage(), this.description, null);
        }
    }
}

