/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.debug;

import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.debug.FidFunctionDebugPanel;
import ghidra.feature.fid.debug.FidSearchResultFrame;
import ghidra.feature.fid.service.FidService;
import ghidra.util.NumericUtilities;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class FidDebugUtils {
    public static final Font MONOSPACED_FONT = new Font("monospaced", 0, 12);

    public static FidSearchResultFrame searchByName(String name, FidService service, FidQueryService fidQueryService) {
        List<FunctionRecord> functionRecords = fidQueryService.findFunctionsByNameSubstring(name);
        return new FidSearchResultFrame("Name: " + name, functionRecords, service, fidQueryService);
    }

    public static FidSearchResultFrame searchByDomainPath(String domainPath, FidService service, FidQueryService fidQueryService) {
        List<FunctionRecord> functionRecords = fidQueryService.findFunctionsByDomainPathSubstring(domainPath);
        return new FidSearchResultFrame("Domain Path: " + domainPath, functionRecords, service, fidQueryService);
    }

    public static FidSearchResultFrame searchByFullHash(long fullHash, FidService service, FidQueryService fidQueryService) {
        List<FunctionRecord> functionRecords = fidQueryService.findFunctionsByFullHash(fullHash);
        return new FidSearchResultFrame(String.format("FH: 0x%x", fullHash), functionRecords, service, fidQueryService);
    }

    public static FidSearchResultFrame searchBySpecificHash(long specificHash, FidService service, FidQueryService fidQueryService) {
        List<FunctionRecord> functionRecords = fidQueryService.findFunctionsBySpecificHash(specificHash);
        return new FidSearchResultFrame(String.format("XH: 0x%x", specificHash), functionRecords, service, fidQueryService);
    }

    public static void openFunctionWindow(FunctionRecord functionRecord, FidService service, FidQueryService fidQueryService) {
        FidFunctionDebugPanel panel = new FidFunctionDebugPanel(service, fidQueryService, functionRecord);
        JScrollPane scrollPane = new JScrollPane(panel);
        String title = String.format("0x%x - %s", functionRecord.getID(), functionRecord.getName());
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(scrollPane);
        frame.pack();
        frame.setVisible(true);
        fidQueryService.addCloseListener(listener -> frame.dispose());
    }

    public static FidSearchResultFrame searchByFunctionID(long id, FidService service, FidQueryService fidQueryService) {
        FunctionRecord functionRecord = fidQueryService.getFunctionByID(id);
        return new FidSearchResultFrame(String.format("Function ID: 0x%x", id), functionRecord == null ? new ArrayList<FunctionRecord>() : new ArrayList<FunctionRecord>(Collections.singletonList(functionRecord)), service, fidQueryService);
    }

    private static void popupNumericParseError(String name, String text) {
        JOptionPane.showMessageDialog(null, "Could not parse " + name + ": " + text);
    }

    public static Long validateHashText(String text, String errorMessage) {
        try {
            long parseLong = NumericUtilities.parseLong((String)text);
            return parseLong;
        }
        catch (NumberFormatException e) {
            FidDebugUtils.popupNumericParseError(errorMessage, text);
            return null;
        }
    }
}

