/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform.shape;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensTransformSupport;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.AbstractLensSupport;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.transform.shape.MagnifyIconGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagnifyImageLensSupport<V, E, M extends LensGraphMouse>
extends AbstractLensSupport<V, E, M> {
    private static final Logger log = LoggerFactory.getLogger(MagnifyImageLensSupport.class);
    protected RenderContext<V, E> renderContext;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected Renderer<V, E> renderer;
    protected Renderer<V, E> transformingRenderer;
    protected GraphElementAccessor<V, E> pickSupport;
    static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>MouseWheel inside lens changes magnification</center></html>";

    public static <V, E, M extends LensGraphMouse> Builder<V, E, M, ?, ?> builder(VisualizationViewer<V, E> vv) {
        return new Builder(vv);
    }

    protected MagnifyImageLensSupport(Builder<V, E, M, ?, ?> builder) {
        super(builder);
        this.renderContext = this.vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.renderer = this.vv.getRenderer();
        this.transformingRenderer = Renderer.builder().build();
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensGraphicsDecorator = new MagnifyIconGraphics(this.lensTransformer);
    }

    protected MagnifyImageLensSupport(VisualizationViewer<V, E> vv, LensTransformer lensTransformer, M lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.renderer = vv.getRenderer();
        this.transformingRenderer = Renderer.builder().build();
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensTransformer = lensTransformer;
        this.lensGraphicsDecorator = new MagnifyIconGraphics(lensTransformer);
    }

    @Override
    public void activate() {
        if (this.allowed()) {
            super.activate();
            this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW));
            if (this.lensPaintable == null) {
                this.lensPaintable = new AbstractLensSupport.LensPaintable(this.lensTransformer);
            }
            if (this.lensControls == null) {
                this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
            }
            Point2D viewCenter = this.vv.getCenter();
            MultiLayerTransformer multiLayerTransformer = this.vv.getRenderContext().getMultiLayerTransformer();
            this.lensTransformer.getLens().setCenter(multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW).inverseTransform(viewCenter));
            double scale = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW).getScale();
            log.trace("view scale is {}", (Object)scale);
            this.lensTransformer.getLens().setRadius((double)Math.min(this.vv.getWidth(), this.vv.getHeight()) / scale / 3.0);
            this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW));
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer);
            this.renderContext.setGraphicsContext(this.lensGraphicsDecorator);
            this.vv.prependPreRenderPaintable(this.lensPaintable);
            this.vv.addPostRenderPaintable(this.lensControls);
            this.vv.setGraphMouse(this.lensGraphMouse);
            this.vv.setToolTipText(instructions);
            this.vv.setTransformSupport(new LensTransformSupport());
            this.vv.repaint();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.renderContext.setPickSupport(this.pickSupport);
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer.getDelegate());
        this.vv.removePreRenderPaintable(this.lensPaintable);
        this.vv.removePostRenderPaintable(this.lensControls);
        this.renderContext.setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setTransformSupport(new TransformSupport());
        this.vv.repaint();
    }

    public static class Builder<V, E, M extends LensGraphMouse, T extends MagnifyImageLensSupport<V, E, M>, B extends Builder<V, E, M, T, B>>
    extends AbstractLensSupport.Builder<V, E, M, T, B> {
        protected Builder(VisualizationViewer<V, E> vv) {
            super(vv);
        }

        @Override
        public T build() {
            return (T)new MagnifyImageLensSupport(this);
        }
    }
}

