/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.selection;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.decorators.ExpandXY;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.spatial.SpatialRTree;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.TreeNode;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.util.AWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapePickSupport<V, E>
implements GraphElementAccessor<V, E> {
    private static final String PICK_AREA_SIZE = "jungrapht.pickAreaSize";
    private static final String PICKING_STYLE = "jungrapht.pickingStyle";
    private static final Logger log;
    protected int pickSize = Integer.getInteger("jungrapht.pickAreaSize", 4);
    protected VisualizationServer<V, E> vv;
    protected Style style = Style.valueOf(System.getProperty("jungrapht.pickingStyle", "CENTERED"));

    public ShapePickSupport(VisualizationServer<V, E> vv, int pickSize) {
        this(vv);
        this.pickSize = pickSize;
    }

    public ShapePickSupport(VisualizationServer<V, E> vv) {
        this.vv = vv;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public V getVertex(LayoutModel<V> layoutModel, Rectangle2D pickingFootprint) {
        if (log.isTraceEnabled()) {
            log.trace("look for vertex intersecting {}", (Object)pickingFootprint);
        }
        MultiLayerTransformer multiLayerTransformer = this.vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        Spatial<V, V> vertexSpatial = this.vv.getVertexSpatial();
        if (!(viewTransformer instanceof LensTransformer) && vertexSpatial.isActive()) {
            return this.getVertex(vertexSpatial, layoutModel, pickingFootprint);
        }
        V closest = null;
        double minDistance = Double.MAX_VALUE;
        if (log.isTraceEnabled()) {
            this.vv.addPreRenderPaintable(new FootprintPaintable(Color.magenta, pickingFootprint));
        }
        block2: while (true) {
            try {
                for (V v : this.getFilteredVertices()) {
                    double dy;
                    Shape shape = this.vv.getRenderContext().getVertexShapeFunction().apply(v);
                    Point p = (Point)layoutModel.apply(v);
                    if (p == null) continue;
                    Point2D p2d = multiLayerTransformer.transform(MultiLayerTransformer.Layer.LAYOUT, p.x, p.y);
                    float x = (float)p2d.getX();
                    float y = (float)p2d.getY();
                    AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                    shape = xform.createTransformedShape(shape);
                    shape = viewTransformer.transform(shape);
                    if (viewTransformer instanceof LensTransformer) {
                        LensTransformer lensTransformer = (LensTransformer)viewTransformer;
                        shape = lensTransformer.getDelegate().transform(shape);
                    }
                    if (log.isTraceEnabled()) {
                        this.vv.addPreRenderPaintable(new FootprintPaintable(Color.pink, shape));
                    }
                    if (!shape.intersects(pickingFootprint)) continue;
                    if (log.isTraceEnabled()) {
                        this.vv.addPreRenderPaintable(new FootprintPaintable(Color.green, shape));
                    }
                    if (this.style == Style.LOWEST) {
                        closest = v;
                        break block2;
                    }
                    if (this.style == Style.HIGHEST) {
                        closest = v;
                        continue;
                    }
                    Rectangle2D bounds = shape.getBounds2D();
                    double dx = bounds.getCenterX() - pickingFootprint.getCenterX();
                    double dist = dx * dx + (dy = bounds.getCenterY() - pickingFootprint.getCenterY()) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    protected V getVertex(Spatial<V, V> spatial, LayoutModel<V> layoutModel, Rectangle2D pickingFootprint) {
        MultiLayerTransformer mlt = this.vv.getRenderContext().getMultiLayerTransformer();
        Point2D pickingCenter = new Point2D.Double(pickingFootprint.getCenterX(), pickingFootprint.getCenterY());
        Set<TreeNode> containingLeafs = spatial.getContainingLeafs(pickingCenter = mlt.inverseTransform(pickingCenter));
        if (containingLeafs == null || containingLeafs.size() == 0) {
            return null;
        }
        RectangularShape union = null;
        for (TreeNode r : containingLeafs) {
            if (union == null) {
                union = r.getBounds();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(r.getBounds());
        }
        double width = union.getWidth();
        double height = union.getHeight();
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        Ellipse2D.Double target = new Ellipse2D.Double(pickingCenter.getX() - radiusx, pickingCenter.getY() - radiusy, width, height);
        if (log.isTraceEnabled()) {
            log.trace("target is {}", (Object)target);
        }
        double minDistance = Double.MAX_VALUE;
        V closest = null;
        Set<V> vertices = spatial.getVisibleElements(target);
        if (log.isTraceEnabled()) {
            log.trace("instead of checking all vertices: {}", this.getFilteredVertices());
            log.trace("out of these candidates: {}...", vertices);
        }
        for (Object v : vertices) {
            double dy;
            Shape shape = this.vv.getRenderContext().getVertexShapeFunction().apply(v);
            Point p = (Point)layoutModel.apply(v);
            if (p == null) continue;
            Point2D p2d = mlt.transform(MultiLayerTransformer.Layer.LAYOUT, p.x, p.y);
            float x = (float)p2d.getX();
            float y = (float)p2d.getY();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            shape = xform.createTransformedShape(shape);
            MutableTransformer viewTransformer = mlt.getTransformer(MultiLayerTransformer.Layer.VIEW);
            shape = viewTransformer.transform(shape);
            if (viewTransformer instanceof LensTransformer) {
                LensTransformer lensTransformer = (LensTransformer)viewTransformer;
                shape = lensTransformer.getDelegate().transform(shape);
            }
            if (!shape.intersects(pickingFootprint)) continue;
            if (this.style == Style.LOWEST) {
                return (V)v;
            }
            if (this.style == Style.HIGHEST) {
                closest = (V)v;
                continue;
            }
            Rectangle2D bounds = shape.getBounds2D();
            double dx = bounds.getCenterX() - pickingCenter.getX();
            double dist = dx * dx + (dy = bounds.getCenterY() - pickingCenter.getY()) * dy;
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = (V)v;
        }
        if (log.isTraceEnabled()) {
            log.trace("selected {} with spatial quadtree", closest);
        }
        return closest;
    }

    public V getVertex(LayoutModel<V> layoutModel, Point p) {
        return this.getVertex(layoutModel, p.x, p.y);
    }

    public V getVertex(LayoutModel<V> layoutModel, double x, double y) {
        MultiLayerTransformer mlt = this.vv.getRenderContext().getMultiLayerTransformer();
        Point2D.Double layoutPoint = new Point2D.Double(x, y);
        Point2D viewPoint = mlt.transform(layoutPoint);
        Rectangle2D.Double pickFootprint = new Rectangle2D.Double(viewPoint.getX() - (double)(this.pickSize / 2), viewPoint.getY() - (double)(this.pickSize / 2), this.pickSize, this.pickSize);
        return this.getVertex(layoutModel, pickFootprint);
    }

    @Override
    public Collection<V> getVertices(LayoutModel<V> layoutModel, Shape shape) {
        HashSet<V> pickedVertices = new HashSet<V>();
        Spatial<V, V> spatial = this.vv.getVertexSpatial();
        if (spatial != null) {
            return this.getContained(spatial, layoutModel, shape);
        }
        while (true) {
            try {
                for (V v : this.getFilteredVertices()) {
                    Point p = (Point)layoutModel.apply(v);
                    if (p == null || !shape.contains(p.x, p.y)) continue;
                    pickedVertices.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedVertices;
    }

    protected Collection<V> getContained(Spatial spatial, LayoutModel<V> layoutModel, Shape shape) {
        HashSet visible = new HashSet(spatial.getVisibleElements(shape));
        if (log.isTraceEnabled()) {
            log.trace("your shape intersects tree cells with these vertices: {}", visible);
        }
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            Object vertex = iterator.next();
            Point p = (Point)layoutModel.apply(vertex);
            if (p == null || shape.contains(p.x, p.y)) continue;
            iterator.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace("these were actually selected: {}", visible);
        }
        return visible;
    }

    protected Collection<E> getContained(SpatialRTree.Edges<E, V> spatial, LayoutModel<V> layoutModel, Shape shape) {
        Set<E> visible = spatial.getVisibleElements(shape);
        if (log.isTraceEnabled()) {
            log.trace("your shape intersects tree cells with these vertices: {}", visible);
        }
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            Object edge = iterator.next();
            Shape edgeShape = this.getTransformedEdgeShape(edge);
            if (edgeShape.intersects(shape.getBounds())) continue;
            iterator.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace("these were actually selected: {}", visible);
        }
        return visible;
    }

    protected E getEdge(SpatialRTree.Edges<E, V> spatial, LayoutModel<V> layoutModel, Rectangle2D pickingFootprint) {
        MultiLayerTransformer mlt = this.vv.getRenderContext().getMultiLayerTransformer();
        Point2D pickingCenter = new Point2D.Double(pickingFootprint.getCenterX(), pickingFootprint.getCenterY());
        Set containingLeafs = spatial.getContainingLeafs(pickingCenter = mlt.inverseTransform(pickingCenter));
        if (containingLeafs == null || containingLeafs.size() == 0) {
            return null;
        }
        RectangularShape union = null;
        for (LeafNode leafNode : containingLeafs) {
            if (union == null) {
                union = leafNode.getBounds();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(leafNode.getBounds());
        }
        double width = union.getWidth();
        double height = union.getHeight();
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        Ellipse2D.Double target = new Ellipse2D.Double(pickingCenter.getX() - radiusx, pickingCenter.getY() - radiusy, width, height);
        if (log.isTraceEnabled()) {
            log.trace("target is {}", (Object)target);
        }
        E closest = null;
        Set<E> edges = spatial.getVisibleElements(target);
        if (log.isTraceEnabled()) {
            log.trace("instead of checking all {} edges: {}", (Object)this.getFilteredEdges().size(), this.getFilteredEdges());
            log.trace("out of these {} candidates: {}...", (Object)edges.size(), edges);
        }
        for (Object edge : edges) {
            Shape edgeShape = this.getTransformedEdgeShape(edge);
            if (edgeShape == null) continue;
            MutableTransformer viewTransformer = mlt.getTransformer(MultiLayerTransformer.Layer.VIEW);
            edgeShape = viewTransformer.transform(edgeShape);
            if (viewTransformer instanceof LensTransformer) {
                LensTransformer lensTransformer = (LensTransformer)viewTransformer;
                edgeShape = lensTransformer.getDelegate().transform(edgeShape);
            }
            Line2D endToEnd = this.getLineFromShape(edgeShape);
            if (edgeShape.contains(pickingFootprint) || !edgeShape.intersects(pickingFootprint) || endToEnd.intersects(pickingFootprint)) continue;
            closest = edge;
            break;
        }
        return closest;
    }

    public E getEdge(LayoutModel<V> layoutModel, Rectangle2D pickFootprint) {
        E closest = null;
        MultiLayerTransformer multiLayerTransformer = this.vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        block2: while (true) {
            try {
                for (E edge : this.getFilteredEdges()) {
                    Shape edgeShape = this.prepareFinalEdgeShape(this.vv.getRenderContext(), layoutModel, edge);
                    if (edgeShape == null) continue;
                    edgeShape = viewTransformer.transform(edgeShape);
                    if (viewTransformer instanceof LensTransformer) {
                        LensTransformer lensTransformer = (LensTransformer)viewTransformer;
                        edgeShape = lensTransformer.getDelegate().transform(edgeShape);
                    }
                    Line2D endToEnd = this.getLineFromShape(edgeShape);
                    if (edgeShape.contains(pickFootprint) || !edgeShape.intersects(pickFootprint) || endToEnd.intersects(pickFootprint)) continue;
                    closest = edge;
                    break block2;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    public E getEdge(LayoutModel<V> layoutModel, double x, double y) {
        MultiLayerTransformer mlt = this.vv.getRenderContext().getMultiLayerTransformer();
        Point2D.Double layoutPoint = new Point2D.Double(x, y);
        Point2D viewPoint = mlt.transform(layoutPoint);
        Rectangle2D.Double pickFootprint = new Rectangle2D.Double(viewPoint.getX() - (double)(this.pickSize / 2), viewPoint.getY() - (double)(this.pickSize / 2), this.pickSize, this.pickSize);
        return this.getEdge(layoutModel, pickFootprint);
    }

    public E getEdge(LayoutModel<V> layoutModel, Point p) {
        return this.getEdge(layoutModel, p.x, p.y);
    }

    protected E getEdge(SpatialRTree.Edges<E, V> spatial, LayoutModel<V> layoutModel, double x, double y) {
        Set containingLeafs = spatial.getContainingLeafs(new Point2D.Double(x, y));
        if (log.isTraceEnabled()) {
            log.trace("leaf for {},{} is {}", new Object[]{x, y, containingLeafs});
        }
        if (containingLeafs == null || containingLeafs.size() == 0) {
            return null;
        }
        RectangularShape union = null;
        for (LeafNode leafNode : containingLeafs) {
            if (union == null) {
                union = leafNode.getBounds();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(leafNode.getBounds());
        }
        double width = union.getWidth();
        double height = union.getHeight();
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        Ellipse2D.Double target = new Ellipse2D.Double(x - radiusx, y - radiusy, width, height);
        if (log.isTraceEnabled()) {
            log.trace("target is {}", (Object)target);
        }
        E closest = null;
        Set<E> edges = spatial.getVisibleElements(target);
        if (log.isTraceEnabled()) {
            log.trace("instead of checking all {} edges: {}", (Object)this.getFilteredEdges().size(), this.getFilteredEdges());
            log.trace("out of these {} candidates: {}...", (Object)edges.size(), edges);
        }
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - (float)(this.pickSize / 2), (float)y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        for (Object edge : edges) {
            Shape edgeShape = this.getTransformedEdgeShape(edge);
            if (edgeShape == null) continue;
            Line2D endToEnd = this.getLineFromShape(edgeShape);
            if (edgeShape.contains(pickArea) || !edgeShape.intersects(pickArea) || endToEnd.intersects(pickArea)) continue;
            closest = edge;
            break;
        }
        return closest;
    }

    private Line2D getLineFromShape(Shape shape) {
        float[] coords = new float[6];
        float startx = 0.0f;
        float starty = 0.0f;
        float endx = 0.0f;
        float endy = 0.0f;
        int segmentCount = 0;
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(coords)) {
                case 0: {
                    startx = coords[0];
                    starty = coords[1];
                    break;
                }
                case 1: {
                    ++segmentCount;
                    endx = coords[0];
                    endy = coords[1];
                    break;
                }
                case 2: {
                    segmentCount += 2;
                    endx = coords[2];
                    endy = coords[3];
                    break;
                }
                case 3: {
                    segmentCount += 2;
                    endx = coords[4];
                    endy = coords[5];
                    break;
                }
            }
            pathIterator.next();
        }
        if (segmentCount > 1) {
            return new Line2D.Float(startx, starty, endx, endy);
        }
        return new Line2D.Float();
    }

    private Shape getTransformedEdgeShape(E e) {
        Object v1 = this.vv.getVisualizationModel().getGraph().getEdgeSource(e);
        Object v2 = this.vv.getVisualizationModel().getGraph().getEdgeTarget(e);
        boolean isLoop = v1.equals(v2);
        LayoutModel<V> layoutModel = this.vv.getVisualizationModel().getLayoutModel();
        Point p1 = (Point)layoutModel.apply(v1);
        Point p2 = (Point)layoutModel.apply(v2);
        if (p1 == null || p2 == null) {
            return null;
        }
        float x1 = (float)p1.x;
        float y1 = (float)p1.y;
        float x2 = (float)p2.x;
        float y2 = (float)p2.y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        Shape edgeShape = this.vv.getRenderContext().getEdgeShapeFunction().apply(this.vv.getVisualizationModel().getGraph(), e);
        if (isLoop) {
            Shape s2 = this.vv.getRenderContext().getVertexShapeFunction().apply(v2);
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            double theta = Math.atan2(dy, dx);
            xform.rotate(theta);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            if (edgeShape instanceof ExpandXY) {
                xform.scale(dist, dist);
            } else {
                xform.scale(dist, 1.0);
            }
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected Collection<V> getFilteredVertices() {
        Set vertices = this.vv.getVisualizationModel().getGraph().vertexSet();
        return this.verticesAreFiltered() ? (Collection)vertices.stream().filter(this.vv.getRenderContext().getVertexIncludePredicate()::test).collect(Collectors.toSet()) : vertices;
    }

    protected Collection<E> getFilteredEdges() {
        Set edges = this.vv.getVisualizationModel().getGraph().edgeSet();
        return this.edgesAreFiltered() ? (Collection)edges.stream().filter(this.vv.getRenderContext().getEdgeIncludePredicate()::test).collect(Collectors.toSet()) : edges;
    }

    protected boolean verticesAreFiltered() {
        Predicate<V> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        return vertexIncludePredicate != null && !vertexIncludePredicate.equals(n -> true);
    }

    protected boolean edgesAreFiltered() {
        Predicate<E> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        return edgeIncludePredicate != null && !edgeIncludePredicate.equals(n -> true);
    }

    protected boolean isVertexRendered(V vertex) {
        Predicate<V> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        return vertexIncludePredicate == null || vertexIncludePredicate.test(vertex);
    }

    protected boolean isEdgeRendered(E edge) {
        Predicate<V> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        Predicate<E> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        Graph<V, E> g = this.vv.getVisualizationModel().getGraph();
        if (edgeIncludePredicate != null && !edgeIncludePredicate.test(edge)) {
            return false;
        }
        Object v1 = g.getEdgeSource(edge);
        Object v2 = g.getEdgeTarget(edge);
        return vertexIncludePredicate == null || vertexIncludePredicate.test(v1) && vertexIncludePredicate.test(v2);
    }

    public float getPickSize() {
        return this.pickSize;
    }

    public void setPickSize(int pickSize) {
        this.pickSize = pickSize;
    }

    protected Shape prepareFinalEdgeShape(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Object source = layoutModel.getGraph().getEdgeSource(e);
        Object target = layoutModel.getGraph().getEdgeTarget(e);
        Point sourcePoint = (Point)layoutModel.apply(source);
        Point targetPoint = (Point)layoutModel.apply(target);
        Point2D sourcePoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, AWT.convert(sourcePoint));
        Point2D targetPoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, AWT.convert(targetPoint));
        float sourcePoint2DX = (float)sourcePoint2D.getX();
        float sourcePoint2DY = (float)sourcePoint2D.getY();
        float targetPoint2DX = (float)targetPoint2D.getX();
        float targetPoint2DY = (float)targetPoint2D.getY();
        boolean isLoop = source.equals(target);
        Shape targetShape = renderContext.getVertexShapeFunction().apply(target);
        Shape edgeShape = this.vv.getRenderContext().getEdgeShapeFunction().apply(layoutModel.getGraph(), e);
        AffineTransform xform = AffineTransform.getTranslateInstance(sourcePoint2DX, sourcePoint2DY);
        if (isLoop) {
            Rectangle2D targetShapeBounds2D = targetShape.getBounds2D();
            xform.scale(targetShapeBounds2D.getWidth(), targetShapeBounds2D.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = targetPoint2DX - sourcePoint2DX;
            float dy = targetPoint2DY - sourcePoint2DY;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (edgeShape instanceof ExpandXY) {
                xform.scale(dist, dist);
            } else {
                xform.scale(dist, 1.0);
            }
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    static {
        PropertyLoader.load();
        log = LoggerFactory.getLogger(ShapePickSupport.class);
    }

    class FootprintPaintable
    implements VisualizationServer.Paintable {
        Shape footPrint;
        Color color;

        public FootprintPaintable(Color color, Shape footPrint) {
            this.color = color;
            this.footPrint = footPrint;
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            ((Graphics2D)g).draw(this.footPrint);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }

    public static enum Style {
        LOWEST,
        CENTERED,
        HIGHEST;

    }
}

