/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.LensTransformSupport;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensKillingGraphMousePlugin<V, E>
extends SelectingGraphMousePlugin<V, E> {
    private static final Logger log = LoggerFactory.getLogger(LensKillingGraphMousePlugin.class);
    Runnable killSwitch;
    protected TransformSupport transformSupport = new LensTransformSupport();

    public void setKillSwitch(Runnable killSwitch) {
        this.killSwitch = killSwitch;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Lens lens;
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        Point2D p = e.getPoint();
        p = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getDelegate().inverseTransform(p) : viewTransformer.inverseTransform(p);
        vv.setCursor(Cursor.getPredefinedCursor(13));
        if (layoutTransformer instanceof LensTransformer) {
            lens = ((LensTransformer)layoutTransformer).getLens();
            this.testLensExit(lens, p);
        }
        if (viewTransformer instanceof LensTransformer) {
            lens = ((LensTransformer)viewTransformer).getLens();
            this.testLensExit(lens, p);
        }
        vv.repaint();
    }

    private void testLensExit(Lens lens, Point2D point) {
        RectangularShape lensShape = lens.getLensShape();
        Ellipse2D.Double killTarget = new Ellipse2D.Double(lensShape.getMinX() + lensShape.getWidth(), lensShape.getMinY(), lensShape.getWidth() / 20.0, lensShape.getHeight() / 20.0);
        if (killTarget.contains(point) && this.killSwitch != null) {
            this.killSwitch.run();
        }
    }

    @Override
    protected Point2D inverseTransform(VisualizationViewer<V, E> vv, Point2D p) {
        return this.transformSupport.inverseTransform(vv, p);
    }

    @Override
    protected Shape transform(VisualizationViewer<V, E> vv, Shape shape) {
        return this.transformSupport.transform(vv, shape);
    }
}

