/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.cmd.DbgToggleExecutionCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetEvent;
import agent.dbgeng.model.iface2.DbgModelTargetEventOption;
import agent.dbgeng.model.iface2.DbgModelTargetException;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ExecutionOption", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class DbgModelTargetExecutionOptionImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetEventOption {
    private DbgModelTargetEvent event;
    private DebugControl.DebugFilterExecutionOption optionExc;

    public DbgModelTargetExecutionOptionImpl(DbgModelTargetEvent event, DebugControl.DebugFilterExecutionOption option) {
        super(event.getModel(), (TargetObject)event, "Execute", "ExecutionOption");
        this.event = event;
        this.getModel().addModelObject((Object)option, (TargetObject)this);
        this.optionExc = option;
        this.setAttributes();
    }

    public DbgModelTargetExecutionOptionImpl(DbgModelTargetException exc, DebugControl.DebugFilterExecutionOption option) {
        super(exc.getModel(), (TargetObject)exc, "Execute", "ExecutionOption");
        this.event = exc;
        this.getModel().addModelObject((Object)option, (TargetObject)this);
        this.optionExc = option;
        this.setAttributes();
    }

    public CompletableFuture<Void> disable() {
        return this.enable();
    }

    public CompletableFuture<Void> enable() {
        int ordinal = (this.optionExc.ordinal() + 1) % (DebugControl.DebugFilterExecutionOption.values().length - 1);
        return this.setOption(ordinal);
    }

    @Override
    public Integer getOption() {
        return this.optionExc.ordinal();
    }

    @Override
    public CompletableFuture<Void> setOption(int ordinal) {
        DbgManagerImpl manager = this.getManager();
        this.optionExc = DebugControl.DebugFilterExecutionOption.getByNumber(ordinal);
        this.setAttributes();
        return manager.execute(new DbgToggleExecutionCommand(manager, this.event.getEventIndex(), this.optionExc));
    }

    public void setAttributes() {
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getName() + " : " + this.optionExc.description, "_value", this.optionExc, "_enabled", this.optionExc.equals((Object)DebugControl.DebugFilterExecutionOption.DEBUG_FILTER_BREAK)), "Refreshed");
    }
}

