/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.OpenMode;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.db.VTMatchTableDBAdapterV0;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchTableDBAdapter {
    static String TABLE_NAME = "MatchTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", ColumnDescription.getColumnFields(), ColumnDescription.getColumnNames());

    static VTMatchTableDBAdapter createAdapter(DBHandle dbHandle, long tableID) throws IOException {
        return new VTMatchTableDBAdapterV0(dbHandle, tableID);
    }

    static VTMatchTableDBAdapter getAdapter(DBHandle dbHandle, long tableID, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchTableDBAdapterV0(dbHandle, tableID, openMode, monitor);
    }

    public abstract DBRecord insertMatchRecord(VTMatchInfo var1, VTMatchSetDB var2, VTAssociationDB var3, VTMatchTagDB var4) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    abstract DBRecord getMatchRecord(long var1) throws IOException;

    abstract int getRecordCount();

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecords(long var1) throws IOException;

    public static enum ColumnDescription {
        TAG_KEY_COL((Field)LongField.INSTANCE),
        MATCH_SET_COL((Field)LongField.INSTANCE),
        SIMILARITY_SCORE_COL((Field)StringField.INSTANCE),
        CONFIDENCE_SCORE_COL((Field)StringField.INSTANCE),
        LENGTH_TYPE((Field)StringField.INSTANCE),
        SOURCE_LENGTH_COL((Field)IntField.INSTANCE),
        DESTINATION_LENGTH_COL((Field)IntField.INSTANCE),
        ASSOCIATION_COL((Field)LongField.INSTANCE);

        private final Field columnField;

        private ColumnDescription(Field columnField) {
            this.columnField = columnField;
        }

        public Field getColumnField() {
            return this.columnField;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Field[] getColumnFields() {
            ColumnDescription[] columns = ColumnDescription.values();
            Field[] fields = new Field[columns.length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = columns[i].getColumnField();
            }
            return fields;
        }
    }
}

