/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSections;
import ghidra.file.formats.android.art.android10.ImageSections_10;
import ghidra.file.formats.android.art.android12.ImageSections_12;
import ghidra.file.formats.android.art.marshmallow.ImageSections_Marshmallow;
import ghidra.file.formats.android.art.nougat.ImageSections_Nougat;
import ghidra.file.formats.android.art.nougat.ImageSections_NougatMR2Pixel;
import ghidra.file.formats.android.art.oreo.ImageSections_Oreo;
import ghidra.file.formats.android.art.oreo.ImageSections_OreoMR1;
import ghidra.file.formats.android.art.pie.ImageSections_Pie;
import java.io.IOException;

public final class ArtImageSectionsFactory {
    public static ArtImageSections getArtImageSections(BinaryReader reader, ArtHeader artHeader) throws IOException {
        switch (artHeader.getVersion()) {
            case "017": {
                return new ImageSections_Marshmallow(reader, artHeader);
            }
            case "029": {
                return new ImageSections_Nougat(reader, artHeader);
            }
            case "030": {
                return new ImageSections_NougatMR2Pixel(reader, artHeader);
            }
            case "043": 
            case "044": {
                return new ImageSections_Oreo(reader, artHeader);
            }
            case "046": {
                return new ImageSections_OreoMR1(reader, artHeader);
            }
            case "056": {
                return new ImageSections_Pie(reader, artHeader);
            }
            case "074": 
            case "085": {
                return new ImageSections_10(reader, artHeader);
            }
            case "099": {
                return new ImageSections_12(reader, artHeader);
            }
        }
        throw new IOException("Unsupported ART version for ImageSections: " + artHeader.getVersion());
    }
}

