/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.util;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.catacombae.util.Util;

public class GUIUtil {
    public static void displayExceptionDialog(Throwable t, Component c) {
        GUIUtil.displayExceptionDialog(t, 10, c, "", "Exception", 0);
    }

    public static void displayExceptionDialog(Throwable t, int maxStackTraceLines, Component c) {
        GUIUtil.displayExceptionDialog(t, maxStackTraceLines, c, "", "Exception", 0);
    }

    public static void displayExceptionDialog(Throwable t, int maxStackTraceLines, Component c, String message) {
        GUIUtil.displayExceptionDialog(t, maxStackTraceLines, c, message, "Exception", 0);
    }

    public static void displayExceptionDialog(Throwable t, int maxStackTraceLines, final Component c, String message, final String title, final int messageType) {
        StringBuilder sb = new StringBuilder();
        if (message.length() > 0) {
            sb.append(message);
            sb.append("\n\n");
        }
        Util.buildStackTrace(t, maxStackTraceLines, sb);
        final String finalMessage = sb.toString();
        try {
            Runnable r = new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(c, finalMessage, title, messageType);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during invokeAndWait!", e);
        }
    }
}

