/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.model.DomainFile;
import java.util.List;

public class ProjectDataOpenDefaultToolAction
extends FrontendProjectTreeAction {
    public ProjectDataOpenDefaultToolAction(String owner, String group) {
        super("Open File", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Open in Default Tool"}));
        this.setKeyBindingData(new KeyBindingData(10, 0));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(ProjectDataContext context) {
        List<DomainFile> selectedFiles = context.getSelectedFiles();
        AppInfo.getActiveProject().getToolServices().launchDefaultTool(selectedFiles.get(0));
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        return context.getSelectedFiles().size() > 0 && context.getSelectedFolders().size() == 0;
    }
}

