/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.breakpoint;

import agent.gdb.manager.parsing.GdbParsingUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GdbBreakpointLocation {
    public static final String WATCHPOINT_LOCATION_PREFIX = "-location ";
    private final long number;
    private final long sub;
    private final boolean enabled;
    private final String addr;
    private final List<Integer> inferiorIds;

    GdbBreakpointLocation(long number, long sub, boolean enabled, String addr, List<Integer> inferiorIds) {
        this.number = number;
        this.sub = sub;
        this.enabled = enabled;
        this.addr = addr;
        this.inferiorIds = Collections.unmodifiableList(inferiorIds);
    }

    public String toString() {
        return "<Loc number=" + this.number + "." + this.sub + ",enabled=" + this.enabled + ",addr=" + this.addr + ",iids=" + this.inferiorIds + ">";
    }

    public long getNumber() {
        return this.number;
    }

    public long getSub() {
        return this.sub;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAddr() {
        return this.addr;
    }

    public long addrAsLong() {
        return GdbParsingUtils.parsePrefixedHex(this.addr);
    }

    public List<Integer> getInferiorIds() {
        return this.inferiorIds;
    }

    public int hashCode() {
        return Objects.hash(this.number, this.sub, this.enabled, this.addr, this.inferiorIds);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GdbBreakpointLocation)) {
            return false;
        }
        GdbBreakpointLocation that = (GdbBreakpointLocation)obj;
        if (this.number != that.number) {
            return false;
        }
        if (this.sub != that.sub) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        if (!Objects.equals(this.addr, that.addr)) {
            return false;
        }
        return Objects.equals(this.inferiorIds, that.inferiorIds);
    }
}

