/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import javax.swing.JComponent;

public class FunctionSignatureDecompilerHover
extends AbstractConfigurableHover
implements DecompilerHoverService {
    private static final String NAME = "Function Signature Display";
    private static final String DESCRIPTION = "Show function signatures when hovering over a function name.";
    private static final int PRIORITY = 20;

    protected FunctionSignatureDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        Varnode vn;
        Scalar scalar;
        Function function;
        if (!this.enabled) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        if (token instanceof ClangFuncNameToken) {
            Function function2 = DecompilerUtils.getFunction(program, (ClangFuncNameToken)token);
            if (function2 == null) {
                return null;
            }
            String content = ToolTipUtils.getToolTipText((Function)function2, (boolean)false);
            return this.createTooltipComponent(content);
        }
        if (token instanceof ClangVariableToken && (function = this.getFunctionAtAddress(program, scalar = this.getScalar(vn = ((ClangVariableToken)token).getVarnode()))) != null) {
            String content = ToolTipUtils.getToolTipText((Function)function, (boolean)false);
            content = content.replaceFirst("<HTML>", "<HTML>" + HTMLUtilities.italic((String)HTMLUtilities.bold((String)"Reference to Function")) + "<br/><br/>");
            return this.createTooltipComponent(content);
        }
        return null;
    }

    private Scalar getScalar(Varnode vn) {
        if (vn == null) {
            return null;
        }
        if (!(vn.getHigh() instanceof HighConstant)) {
            return null;
        }
        HighConstant hv = (HighConstant)vn.getHigh();
        long offset = vn.getOffset();
        int sz = vn.getSize();
        boolean isSigned = true;
        if (hv.getDataType() instanceof AbstractIntegerDataType) {
            isSigned = ((AbstractIntegerDataType)hv.getDataType()).isSigned();
        }
        if (sz > 8) {
            return null;
        }
        return new Scalar(sz * 8, offset, isSigned);
    }

    private Function getFunctionAtAddress(Program program, Scalar scalar) {
        if (scalar == null) {
            return null;
        }
        long scalarLong = scalar.getValue();
        AddressFactory factory = program.getAddressFactory();
        AddressSpace space = factory.getDefaultAddressSpace();
        try {
            Address asAddress = factory.getAddress(space.getSpaceID(), scalarLong);
            return program.getListing().getFunctionAt(asAddress);
        }
        catch (AddressOutOfBoundsException ex) {
            return null;
        }
    }
}

