/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TokenHighlights
implements Iterable<HighlightToken> {
    private Map<TokenKey, HighlightToken> highlightsByToken = new HashMap<TokenKey, HighlightToken>();

    public Map<String, Color> copyHighlightsByName() {
        HashMap<String, Color> results = new HashMap<String, Color>();
        Collection<HighlightToken> values = this.highlightsByToken.values();
        for (HighlightToken hl : values) {
            String name = hl.getToken().getText();
            results.put(name, hl.getColor());
        }
        return results;
    }

    private TokenKey getKey(HighlightToken ht) {
        return new TokenKey(ht);
    }

    private TokenKey getKey(ClangToken t) {
        return new TokenKey(t);
    }

    private Function getFunction(ClangToken t) {
        ClangFunction cFunction = t.getClangFunction();
        if (cFunction == null) {
            return null;
        }
        HighFunction highFunction = cFunction.getHighFunction();
        if (highFunction == null) {
            return null;
        }
        return highFunction.getFunction();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.highlightsByToken.size();
    }

    public void add(HighlightToken t) {
        this.highlightsByToken.put(this.getKey(t), t);
    }

    public HighlightToken get(ClangToken t) {
        return this.highlightsByToken.get(this.getKey(t));
    }

    public Set<HighlightToken> getHighlightsByFunction(Function f) {
        HashSet<HighlightToken> results = new HashSet<HighlightToken>();
        Set<TokenKey> keys = this.getHighlightKeys(f);
        for (TokenKey key : keys) {
            HighlightToken hl = this.highlightsByToken.get(key);
            results.add(hl);
        }
        return results;
    }

    public boolean contains(ClangToken t) {
        return this.highlightsByToken.containsKey(this.getKey(t));
    }

    public void clear() {
        this.highlightsByToken.clear();
    }

    public void remove(ClangToken t) {
        this.highlightsByToken.remove(this.getKey(t));
    }

    public Set<HighlightToken> removeHighlightsByFunction(Function function) {
        HashSet<HighlightToken> oldHighlights = new HashSet<HighlightToken>();
        Set<TokenKey> keys = this.getHighlightKeys(function);
        for (TokenKey key : keys) {
            HighlightToken hl = this.highlightsByToken.remove(key);
            oldHighlights.add(hl);
        }
        return oldHighlights;
    }

    private Set<TokenKey> getHighlightKeys(Function function) {
        HashSet<TokenKey> results = new HashSet<TokenKey>();
        Set<Map.Entry<TokenKey, HighlightToken>> entries = this.highlightsByToken.entrySet();
        for (Map.Entry<TokenKey, HighlightToken> entry : entries) {
            HighlightToken highlight = entry.getValue();
            ClangToken token = highlight.getToken();
            Function tokenFunction = this.getFunction(token);
            if (!function.equals(tokenFunction)) continue;
            results.add(entry.getKey());
        }
        return results;
    }

    @Override
    public Iterator<HighlightToken> iterator() {
        return this.highlightsByToken.values().iterator();
    }

    public String toString() {
        return this.highlightsByToken.values().toString();
    }

    private class TokenKey {
        private ClangToken token;

        TokenKey(ClangToken token) {
            this.token = Objects.requireNonNull(token);
        }

        public TokenKey(HighlightToken t) {
            this(t.getToken());
        }

        public int hashCode() {
            String text = this.token.getText();
            return text == null ? 0 : text.hashCode();
        }

        public boolean equals(Object obj) {
            int otherPositionInLine;
            ClangLine otherLineParent;
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClangToken otherToken = ((TokenKey)obj).token;
            if (this.token.getClass() != otherToken.getClass()) {
                return false;
            }
            if (!Objects.equals(this.token.getText(), otherToken.getText())) {
                return false;
            }
            ClangLine lineParent = this.token.getLineParent();
            if (!this.sameLines(lineParent, otherLineParent = otherToken.getLineParent())) {
                return false;
            }
            if (lineParent == null) {
                return false;
            }
            int positionInLine = lineParent.indexOfToken(this.token);
            return positionInLine == (otherPositionInLine = otherLineParent.indexOfToken(otherToken));
        }

        private boolean sameLines(ClangLine l1, ClangLine l2) {
            if (l1 == null) {
                return l2 == null;
            }
            if (l2 == null) {
                return false;
            }
            return l1.getLineNumber() == l2.getLineNumber();
        }

        public String toString() {
            return this.token.toString();
        }
    }
}

