/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.BoolVector;
import SevenZip.Archive.Common.OutStreamWithCRC;
import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import SevenZip.Archive.SevenZip.FileItem;
import java.io.IOException;
import java.io.OutputStream;

class FolderOutStream
extends OutputStream {
    OutStreamWithCRC _outStreamWithHashSpec = new OutStreamWithCRC();
    OutputStream _outStreamWithHash = this._outStreamWithHashSpec;
    ArchiveDatabaseEx _archiveDatabase;
    BoolVector _extractStatuses;
    int _startIndex;
    int _ref2Offset;
    IArchiveExtractCallback _extractCallback;
    boolean _testMode;
    int _currentIndex;
    boolean _fileIsOpen;
    long _filePos;

    public int Init(ArchiveDatabaseEx archiveDatabaseEx, int n, int n2, BoolVector boolVector, IArchiveExtractCallback iArchiveExtractCallback, boolean bl) throws IOException {
        this._archiveDatabase = archiveDatabaseEx;
        this._ref2Offset = n;
        this._startIndex = n2;
        this._extractStatuses = boolVector;
        this._extractCallback = iArchiveExtractCallback;
        this._testMode = bl;
        this._currentIndex = 0;
        this._fileIsOpen = false;
        return this.WriteEmptyFiles();
    }

    int OpenFile() throws IOException {
        int n = this._startIndex + this._currentIndex;
        OutputStream[] outputStreamArray = new OutputStream[1];
        int n2 = this._extractStatuses.get(this._currentIndex) ? (this._testMode ? 1 : 0) : 2;
        int n3 = this._extractCallback.GetStream(this._ref2Offset + n, outputStreamArray, n2);
        if (n3 != 0) {
            return n3;
        }
        OutputStream outputStream = outputStreamArray[0];
        this._outStreamWithHashSpec.SetStream(outputStream);
        this._outStreamWithHashSpec.Init();
        if (n2 == 0 && outputStream == null) {
            FileItem fileItem = (FileItem)this._archiveDatabase.Files.get(n);
            if (!fileItem.IsAnti && !fileItem.IsDirectory) {
                n2 = 2;
            }
        }
        return this._extractCallback.PrepareOperation(n2);
    }

    int WriteEmptyFiles() throws IOException {
        while (this._currentIndex < this._extractStatuses.size()) {
            int n = this._startIndex + this._currentIndex;
            FileItem fileItem = (FileItem)this._archiveDatabase.Files.get(n);
            if (!fileItem.IsAnti && !fileItem.IsDirectory && fileItem.UnPackSize != 0L) {
                return 0;
            }
            int n2 = this.OpenFile();
            if (n2 != 0) {
                return n2;
            }
            n2 = this._extractCallback.SetOperationResult(0);
            if (n2 != 0) {
                return n2;
            }
            this._outStreamWithHashSpec.ReleaseStream();
            ++this._currentIndex;
        }
        return 0;
    }

    @Override
    public void write(int n) throws IOException {
        throw new IOException("FolderOutStream - write() not implemented");
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (this._currentIndex < this._extractStatuses.size()) {
            int n4;
            if (this._fileIsOpen) {
                int n5;
                int n6;
                n4 = this._startIndex + this._currentIndex;
                FileItem fileItem = (FileItem)this._archiveDatabase.Files.get(n4);
                int n7 = n2 - n3;
                long l = fileItem.UnPackSize;
                long l2 = (int)(l - this._filePos);
                if ((long)n7 < l2) {
                    l2 = n7;
                }
                int n8 = n6 = (int)l2;
                this._outStreamWithHash.write(byArray, n3 + n, n6);
                this._filePos += (long)n8;
                n3 += n8;
                if (this._filePos == l) {
                    n5 = fileItem.IsFileCRCDefined ? (fileItem.FileCRC == this._outStreamWithHashSpec.GetCRC() ? 1 : 0) : 1;
                    int n9 = this._extractCallback.SetOperationResult(n5 != 0 ? 0 : 3);
                    if (n9 != 0) {
                        throw new IOException("_extractCallback.SetOperationResult : " + n9);
                    }
                    this._outStreamWithHashSpec.ReleaseStream();
                    this._fileIsOpen = false;
                    ++this._currentIndex;
                }
                if (n3 != n2) continue;
                n5 = this.WriteEmptyFiles();
                if (n5 != 0) {
                    throw new IOException("WriteEmptyFiles : " + n5);
                }
                return;
            }
            n4 = this.OpenFile();
            if (n4 != 0) {
                throw new IOException("OpenFile : " + n4);
            }
            this._fileIsOpen = true;
            this._filePos = 0L;
        }
    }

    public int FlushCorrupted(int n) throws IOException {
        while (this._currentIndex < this._extractStatuses.size()) {
            int n2;
            if (this._fileIsOpen) {
                n2 = this._extractCallback.SetOperationResult(n);
                if (n2 != 0) {
                    return n2;
                }
                this._outStreamWithHashSpec.ReleaseStream();
                this._fileIsOpen = false;
                ++this._currentIndex;
                continue;
            }
            n2 = this.OpenFile();
            if (n2 != 0) {
                return n2;
            }
            this._fileIsOpen = true;
        }
        return 0;
    }

    public int WasWritingFinished() {
        int n = this._extractStatuses.size();
        if (this._currentIndex == n) {
            return 0;
        }
        return -2147467259;
    }
}

