/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.ElementStyle;
import com.informagen.giv.ElementType;
import com.informagen.giv.GIVColors;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapPanel;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapView;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GIVXMLHandler
extends DefaultHandler {
    final Stack stack = new Stack();
    final StringBuffer pcdata = new StringBuffer();
    private final Hashtable elementTypeTable = new Hashtable();
    private final Hashtable elementStyleTable = new Hashtable();
    private final ElementStyle defaultElementStyle = new ElementStyle("Default");
    private final Stack groupStack = new Stack();
    String mapName;
    int minExtent;
    int maxExtent;
    private MapView mapView;
    private MapPanel mapPanel;
    ElementStyle elementStyle;

    GIVXMLHandler(MapView mapView) {
        this.mapView = mapView;
        int n = 0;
        this.defaultElementStyle.labelDisplay(n);
        int n2 = 0;
        this.defaultElementStyle.labelPosition(n2);
        this.defaultElementStyle.barHeight(4);
        this.defaultElementStyle.setColor(GIVColors.getColor("Black"));
    }

    public void startDocument() {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.pcdata.append(cArray, n, n2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.pcdata.setLength(0);
        String string4 = this.stack.empty() ? "" : (String)this.stack.peek();
        this.stack.push(string2);
        if (string2.equals("giv")) {
            this.mapName = attributes.getValue("name");
        } else if (string2.equals("view")) {
            this.doView(attributes);
        } else if (string2.equals("map-panel")) {
            this.doMapPanel(attributes);
        } else if (string2.equals("style-for")) {
            this.doStyleFor(attributes);
        } else if (string2.equals("group")) {
            this.doGroup(attributes);
        } else if (string2.equals("element")) {
            this.doElement(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        this.stack.pop();
        String string5 = string4 = this.stack.empty() ? "" : (String)this.stack.peek();
        if (string2.equals("map-panel")) {
            this.mapPanel = null;
        } else if (string2.equals("style-for")) {
            if (this.elementStyle != null) {
                String string6 = this.pcdata.toString();
                this.elementStyle.setStyleName(string6);
                this.elementStyleTable.put(string6, this.elementStyle);
            }
            this.elementStyle = null;
        } else if (string2.equals("group")) {
            MapTile mapTile = (MapTile)this.groupStack.pop();
            if (this.groupStack.empty() && this.mapPanel != null) {
                this.mapPanel.add(mapTile);
            } else {
                ((MapTile)this.groupStack.peek()).add(mapTile);
            }
        }
    }

    public void endDocument() throws SAXException {
        this.stack.removeAllElements();
        this.pcdata.setLength(0);
    }

    private void doView(Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        double d = Double.valueOf(this.getAttribute(attributes, "edge", "0.01"));
        int n3 = n2 - n + 1;
        this.minExtent = n - (int)((double)n3 * d);
        this.maxExtent = n2 + (int)((double)n3 * d);
        this.mapView.setExtent(this.minExtent, this.maxExtent);
    }

    private void doMapPanel(Attributes attributes) {
        String string = this.getAttribute(attributes, "label", "");
        String string2 = this.getAttribute(attributes, "bkg-color", "White");
        String string3 = this.getAttribute(attributes, "buoyancy", "Floating");
        int n = Integer.parseInt(this.getAttribute(attributes, "h-gap", "1"));
        int n2 = Integer.parseInt(this.getAttribute(attributes, "v-gap", "1"));
        this.mapPanel = new MapPanel();
        this.mapPanel.setBuoyancy(string3, n, n2);
        this.mapPanel.setWallpaper(GIVColors.getColor(string2));
        this.mapPanel.setTitle(string);
        this.mapPanel.setExtent(this.minExtent, this.maxExtent);
        this.mapView.add(this.mapPanel);
        this.elementStyleTable.clear();
    }

    private void doStyleFor(Attributes attributes) {
        String string = this.getAttribute(attributes, "color", "White");
        String string2 = this.getAttribute(attributes, "lbl-display", "Bigger");
        String string3 = this.getAttribute(attributes, "lbl-position", "Below");
        int n = Integer.parseInt(this.getAttribute(attributes, "bar-height", "5"));
        String string4 = this.getAttribute(attributes, "start-edge-style", "Blunt");
        String string5 = this.getAttribute(attributes, "stop-edge-style", "Blunt");
        this.elementStyle = new ElementStyle();
        int n2 = 1;
        if (string2.equalsIgnoreCase("Always")) {
            n2 = 0;
        } else if (string2.equalsIgnoreCase("Bigger")) {
            n2 = 1;
        } else if (string2.equalsIgnoreCase("Never")) {
            n2 = 2;
        }
        this.elementStyle.labelDisplay(n2);
        int n3 = 0;
        if (string4.equalsIgnoreCase("Blunt")) {
            n3 = 0;
        } else if (string4.equalsIgnoreCase("ChiselTop")) {
            n3 = 1;
        } else if (string4.equalsIgnoreCase("Point")) {
            n3 = 2;
        } else if (string4.equalsIgnoreCase("Tail")) {
            n3 = 4;
        } else if (string4.equalsIgnoreCase("ChiselBottom")) {
            n3 = 3;
        }
        this.elementStyle.setStartEdgeStyle(n3);
        n3 = 0;
        if (string5.equalsIgnoreCase("Blunt")) {
            n3 = 0;
        } else if (string5.equalsIgnoreCase("ChiselTop")) {
            n3 = 1;
        } else if (string5.equalsIgnoreCase("Point")) {
            n3 = 2;
        } else if (string5.equalsIgnoreCase("Tail")) {
            n3 = 4;
        } else if (string5.equalsIgnoreCase("ChiselBottom")) {
            n3 = 3;
        }
        this.elementStyle.setStopEdgeStyle(n3);
        int n4 = 0;
        if (string3.equalsIgnoreCase("Below")) {
            n4 = 0;
        } else if (string3.equalsIgnoreCase("Above")) {
            n4 = 1;
        }
        this.elementStyle.labelPosition(n4);
        this.elementStyle.barHeight(n);
        this.elementStyle.setColor(GIVColors.getColor(string));
    }

    private void doGroup(Attributes attributes) {
        String string = this.getAttribute(attributes, "label", "");
        String string2 = this.getAttribute(attributes, "bkg-color", "White");
        String string3 = this.getAttribute(attributes, "buoyancy", "Floating");
        int n = Integer.parseInt(this.getAttribute(attributes, "h-gap", "1"));
        int n2 = Integer.parseInt(this.getAttribute(attributes, "v-gap", "1"));
        MapTile mapTile = new MapTile();
        mapTile.setBuoyancy(string3, n, n2);
        mapTile.setLabel(string);
        if (string2 != null) {
            mapTile.setBkgColor(GIVColors.getColor(string2));
        }
        this.groupStack.push(mapTile);
    }

    private void doElement(Attributes attributes) {
        ElementStyle elementStyle;
        int n = Integer.parseInt(this.getAttribute(attributes, "from", "0"));
        int n2 = Integer.parseInt(this.getAttribute(attributes, "to", "0"));
        String string = this.getAttribute(attributes, "name", "");
        attributes.getValue("name");
        String string2 = this.getAttribute(attributes, "type", "default");
        ElementType elementType = (ElementType)this.elementTypeTable.get(string2);
        if (elementType == null && !string2.equals("")) {
            elementType = new ElementType(string2);
            this.elementTypeTable.put(string2, elementType);
        }
        if ((elementStyle = (ElementStyle)this.elementStyleTable.get(string2)) == null) {
            elementStyle = this.defaultElementStyle;
        }
        MapGlyph mapGlyph = new MapGlyph(string, n, n2, elementStyle, elementType);
        if (this.groupStack.empty()) {
            this.mapPanel.add(mapGlyph);
        } else {
            ((MapTile)this.groupStack.peek()).add(mapGlyph);
        }
    }

    private String getAttribute(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }
}

