/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoTerm;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.ws.seqdb.EbiDbEntry;
import org.forester.ws.seqdb.SequenceDatabaseEntry;
import org.forester.ws.seqdb.UniProtEntry;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class SequenceDbWsTools {
    public static final String BASE_UNIPROT_URL = "https://www.uniprot.org/";
    public static final int DEFAULT_LINES_TO_RETURN = 4000;
    public static final String EMBL_DBS_REFSEQ_N = "refseqn";
    public static final String EMBL_DBS_REFSEQ_P = "refseqp";
    public static final String EMBL_GENBANK = "https://www.ebi.ac.uk/Tools/dbfetch/dbfetch?db=GENBANK&style=raw&id=";
    public static final String EMBL_REFSEQN = "https://www.ebi.ac.uk/Tools/dbfetch/dbfetch?db=refseqn&style=raw&id=";
    public static final String EMBL_EMBL = "https://www.ebi.ac.uk/Tools/dbfetch/dbfetch?db=EMBL&style=raw&id=";
    private static final boolean DEBUG = false;
    private static final String URL_ENC = "UTF-8";
    private static final int SLEEP = 200;
    private static final boolean ALLOW_TO_OVERWRITE_MOL_SEQ = false;

    public static List<UniProtTaxonomy> getTaxonomiesFromCommonNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = SequenceDbWsTools.getTaxonomiesFromCommonName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getCommonName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromId(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromId(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromScientificNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = SequenceDbWsTools.getTaxonomiesFromScientificName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getScientificName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string, int n) throws IOException {
        String string2 = new String(string);
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromTaxonomyCode(string2, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static SequenceDatabaseEntry obtainEmblEntry(Accession accession) throws IOException {
        return SequenceDbWsTools.obtainEmblEntry(accession, 4000);
    }

    public static SequenceDatabaseEntry obtainEmblEntry(Accession accession, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryEmblDb(accession, n);
        return EbiDbEntry.createInstance(list);
    }

    public static SequenceDatabaseEntry obtainEntry(String string) throws IOException {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("cannot not extract sequence db accessor from null or empty string");
        }
        Accession accession = SequenceAccessionTools.parseAccessorFromString(string);
        if (accession == null) {
            throw new IllegalArgumentException("could not extract acceptable sequence db accessor from \"" + string + "\"");
        }
        if (accession.getSource().equals(Accession.Source.REFSEQ.toString()) || accession.getSource().equals(Accession.Source.EMBL.toString()) || accession.getSource().equals(Accession.Source.NCBI.toString())) {
            return SequenceDbWsTools.obtainEmblEntry(accession, 4000);
        }
        if (accession.getSource().equals(Accession.Source.UNIPROT.toString())) {
            return SequenceDbWsTools.obtainUniProtEntry(accession.getValue(), 4000);
        }
        throw new IllegalArgumentException("don't know how to handle request for source \"" + accession.getSource() + "\"");
    }

    public static SequenceDatabaseEntry obtainRefSeqEntryFromEmbl(Accession accession) throws IOException {
        return SequenceDbWsTools.obtainRefSeqEntryFromEmbl(accession, 4000);
    }

    public static SequenceDatabaseEntry obtainRefSeqEntryFromEmbl(Accession accession, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryEmblDbForRefSeqEntry(accession, n);
        return EbiDbEntry.createInstance(list);
    }

    public static final Accession obtainSeqAccession(PhylogenyNode phylogenyNode) {
        Accession accession = SequenceAccessionTools.obtainFromSeqAccession(phylogenyNode);
        if (!SequenceDbWsTools.isAccessionAcceptable(accession)) {
            accession = SequenceAccessionTools.obtainAccessorFromDataFields(phylogenyNode);
        }
        return accession;
    }

    public static final void obtainSeqInformation(boolean bl, int n, SortedSet<String> sortedSet, PhylogenyNode phylogenyNode) throws IOException {
        Accession accession = SequenceDbWsTools.obtainSeqAccession(phylogenyNode);
        if (!SequenceDbWsTools.isAccessionAcceptable(accession)) {
            if (phylogenyNode.isExternal() || !phylogenyNode.isEmpty()) {
                sortedSet.add(phylogenyNode.toString());
            }
        } else {
            SequenceDbWsTools.addDataFromDbToNode(bl, n, sortedSet, phylogenyNode, accession);
        }
    }

    public static final void obtainSeqInformation(boolean bl, SortedSet<String> sortedSet, PhylogenyNode phylogenyNode) throws IOException {
        SequenceDbWsTools.obtainSeqInformation(bl, 4000, sortedSet, phylogenyNode);
    }

    public static final SortedSet<String> obtainSeqInformation(Phylogeny phylogeny, boolean bl, boolean bl2, int n) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isExternal() && bl) continue;
            SequenceDbWsTools.obtainSeqInformation(bl2, n, treeSet, phylogenyNode);
        }
        return treeSet;
    }

    public static final void obtainSeqInformation(PhylogenyNode phylogenyNode) throws IOException {
        SequenceDbWsTools.obtainSeqInformation(true, 4000, new TreeSet<String>(), phylogenyNode);
    }

    public static SequenceDatabaseEntry obtainUniProtEntry(String string) throws IOException {
        return SequenceDbWsTools.obtainUniProtEntry(string, 4000);
    }

    public static SequenceDatabaseEntry obtainUniProtEntry(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryUniprot("uniprot/" + string + ".txt", n);
        return UniProtEntry.createInstance(list);
    }

    public static List<String> queryDb(String string, int n, String string2) throws IOException {
        String string3;
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to use empty query ");
        }
        if (n < 1) {
            n = 1;
        }
        URL uRL = new URL(string2 + string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
            if (arrayList.size() <= n) continue;
        }
        bufferedReader.close();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return arrayList;
    }

    public static List<String> queryEmblDb(Accession accession, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (accession.getSource().equals(Accession.Source.NCBI.toString())) {
            stringBuilder.append(EMBL_GENBANK);
        } else if (accession.getSource().equals(Accession.Source.REFSEQ.toString())) {
            stringBuilder.append(EMBL_REFSEQN);
        } else if (accession.getSource().equals(Accession.Source.EMBL.toString())) {
            stringBuilder.append(EMBL_EMBL);
        } else {
            throw new IllegalArgumentException("unable to handle source: " + accession.getSource());
        }
        return SequenceDbWsTools.queryDb(accession.getValue(), n, stringBuilder.toString());
    }

    public static List<String> queryEmblDbForRefSeqEntry(Accession accession, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EMBL_REFSEQN);
        return SequenceDbWsTools.queryDb(accession.getValue(), n, stringBuilder.toString());
    }

    public static List<String> queryUniprot(String string, int n) throws IOException {
        return SequenceDbWsTools.queryDb(string, n, BASE_UNIPROT_URL);
    }

    static final String extractFrom(String string, String string2) {
        int n = string.indexOf(string2);
        return string.substring(n + string2.length()).trim();
    }

    static final String extractFromTo(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3);
        if (n < 0 || n2 < n) {
            return "";
        }
        return string.substring(n + string2.length(), n2).trim();
    }

    static final String extractTo(String string, String string2) {
        int n = string.indexOf(string2);
        return string.substring(0, n).trim();
    }

    private static void addDataFromDbToNode(boolean bl, int n, SortedSet<String> sortedSet, PhylogenyNode phylogenyNode, Accession accession) throws IOException {
        SequenceDatabaseEntry sequenceDatabaseEntry = null;
        String string = accession.getValue();
        if (accession.getSource().equals(Accession.Source.UNIPROT.toString())) {
            try {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainUniProtEntry(string, n);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (accession.getSource().equals(Accession.Source.REFSEQ.toString())) {
            try {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainRefSeqEntryFromEmbl(new Accession(string), n);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (accession.getSource().equals(Accession.Source.EMBL.toString()) || accession.getSource().equals(Accession.Source.NCBI.toString()) || accession.getSource().equals(Accession.Source.EMBL.toString())) {
            try {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainEmblEntry(accession, n);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (accession.getSource().equals(Accession.Source.GI.toString())) {
            try {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainRefSeqEntryFromEmbl(new Accession(string), n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (sequenceDatabaseEntry != null && !sequenceDatabaseEntry.isEmpty()) {
            PhylogenyData phylogenyData;
            Object object;
            Sequence sequence;
            Sequence sequence2 = sequence = phylogenyNode.getNodeData().isHasSequence() ? phylogenyNode.getNodeData().getSequence() : new Sequence();
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getAccession())) {
                sequence.setAccession(new Accession(sequenceDatabaseEntry.getAccession(), accession.getSource()));
            }
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceName())) {
                sequence.setName(sequenceDatabaseEntry.getSequenceName());
            }
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getGeneName())) {
                sequence.setGeneName(sequenceDatabaseEntry.getGeneName());
            }
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceSymbol())) {
                try {
                    sequence.setSymbol(sequenceDatabaseEntry.getSequenceSymbol());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    // empty catch block
                }
            }
            if (sequenceDatabaseEntry.getMolecularSequence() != null && !ForesterUtil.isEmpty(sequenceDatabaseEntry.getMolecularSequence().getMolecularSequenceAsString()) && sequence.getMolecularSequence().isEmpty()) {
                sequence.setMolecularSequence(sequenceDatabaseEntry.getMolecularSequence().getMolecularSequenceAsString());
                sequence.setMolecularSequenceAligned(false);
                if (sequenceDatabaseEntry.getMolecularSequence().getType() == MolecularSequence.TYPE.AA) {
                    sequence.setType("protein");
                } else if (sequenceDatabaseEntry.getMolecularSequence().getType() == MolecularSequence.TYPE.DNA) {
                    sequence.setType("dna");
                } else if (sequenceDatabaseEntry.getMolecularSequence().getType() == MolecularSequence.TYPE.RNA) {
                    sequence.setType("rna");
                }
            }
            if (sequenceDatabaseEntry.getGoTerms() != null && !sequenceDatabaseEntry.getGoTerms().isEmpty()) {
                object = sequenceDatabaseEntry.getGoTerms().iterator();
                while (object.hasNext()) {
                    phylogenyData = (GoTerm)object.next();
                    Annotation annotation = new Annotation(phylogenyData.getGoId().getId());
                    annotation.setDesc(phylogenyData.getName());
                    sequence.addAnnotation(annotation);
                }
            }
            if (sequenceDatabaseEntry.getCrossReferences() != null && !sequenceDatabaseEntry.getCrossReferences().isEmpty()) {
                object = sequenceDatabaseEntry.getCrossReferences().iterator();
                while (object.hasNext()) {
                    phylogenyData = (Accession)object.next();
                    sequence.addCrossReference((Accession)phylogenyData);
                }
            }
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getChromosome()) && !ForesterUtil.isEmpty(sequenceDatabaseEntry.getMap())) {
                sequence.setLocation("chr " + sequenceDatabaseEntry.getChromosome() + ", " + sequenceDatabaseEntry.getMap());
            } else if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getChromosome())) {
                sequence.setLocation("chr " + sequenceDatabaseEntry.getChromosome());
            } else if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getMap())) {
                sequence.setLocation(sequenceDatabaseEntry.getMap());
            }
            Object object2 = object = phylogenyNode.getNodeData().isHasTaxonomy() ? phylogenyNode.getNodeData().getTaxonomy() : new Taxonomy();
            if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyScientificName())) {
                ((Taxonomy)object).setScientificName(sequenceDatabaseEntry.getTaxonomyScientificName());
            }
            if (bl && !ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyIdentifier())) {
                ((Taxonomy)object).setIdentifier(new Identifier(sequenceDatabaseEntry.getTaxonomyIdentifier(), "uniprot"));
            }
            phylogenyNode.getNodeData().setTaxonomy((Taxonomy)object);
            phylogenyNode.getNodeData().setSequence(sequence);
        } else if (phylogenyNode.isExternal() || !phylogenyNode.isEmpty()) {
            sortedSet.add(phylogenyNode.toString());
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string.trim(), URL_ENC);
    }

    private static List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromCommonName(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    private static List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromScientificName(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    private static List<String> getTaxonomyStringFromCommonName(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=common%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromId(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=id%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromScientificName(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=scientific%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromTaxonomyCode(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=mnemonic%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static final boolean isAccessionAcceptable(Accession accession) {
        return accession != null && !ForesterUtil.isEmpty(accession.getSource()) && !ForesterUtil.isEmpty(accession.getValue()) && (!accession.getSource().equals(Accession.Source.UNIPROT.toString()) || !accession.getSource().toString().equals(Accession.Source.EMBL.toString()) || !accession.getSource().toString().equals(Accession.Source.REFSEQ.toString()));
    }

    private static List<UniProtTaxonomy> parseUniProtTaxonomy(List<String> list) throws IOException {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        for (String string : list) {
            if (ForesterUtil.isEmpty(string)) continue;
            if (string.startsWith("Taxon")) {
                String[] stringArray = string.split("\t");
                if (stringArray[1].equalsIgnoreCase("Mnemonic") && stringArray[2].equalsIgnoreCase("Scientific name") && stringArray[3].equalsIgnoreCase("Common name") && stringArray[4].equalsIgnoreCase("Synonym") && stringArray[5].equalsIgnoreCase("Other Names") && stringArray[6].equalsIgnoreCase("Reviewed") && stringArray[7].equalsIgnoreCase("Rank") && stringArray[8].equalsIgnoreCase("Lineage")) continue;
                throw new IOException("Unreconized UniProt Taxonomy format: " + string);
            }
            if (string.split("\t").length <= 4) continue;
            arrayList.add(new UniProtTaxonomy(string));
        }
        return arrayList;
    }
}

