/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class PhylogenyDecorator {
    private static final String TP_NODE_NAME = "NODE_NAME";
    private static final String TP_SEQ_ACCESSION = "SEQ_ACCESSION";
    private static final String TP_SEQ_ACCESSION_SOURCE = "SEQ_ACCESSION_SOURCE";
    private static final String TP_SEQ_ANNOTATION_DESC = "SEQ_ANNOTATION_DESC";
    private static final String TP_SEQ_ANNOTATION_REF = "SEQ_ANNOTATION_REF";
    private static final String TP_SEQ_MOL_SEQ = "SEQ_MOL_SEQ";
    private static final String TP_SEQ_NAME = "SEQ_NAME";
    private static final String TP_SEQ_SYMBOL = "SEQ_SYMBOL";
    private static final String TP_TAXONOMY_CN = "TAXONOMY_CN";
    private static final String TP_TAXONOMY_CODE = "TAXONOMY_CODE";
    private static final String TP_TAXONOMY_ID = "TAXONOMY_ID";
    private static final String TP_TAXONOMY_ID_PROVIDER = "TAXONOMY_ID_PROVIDER";
    private static final String TP_TAXONOMY_SN = "TAXONOMY_SN";
    private static final String TP_TAXONOMY_SYN = "TAXONOMY_SYN";

    private PhylogenyDecorator() {
    }

    public static void decorate(Phylogeny phylogeny, Map<String, Map<String, String>> map, boolean bl) throws IllegalArgumentException, PhyloXmlDataFormatException {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getName();
            if (ForesterUtil.isEmpty(string)) continue;
            if (map.containsKey(string)) {
                Annotation annotation;
                Map<String, String> map2 = map.get(string);
                if (map2 == null) continue;
                if (map2.containsKey(TP_TAXONOMY_CODE)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(map2.get(TP_TAXONOMY_CODE));
                }
                if (map2.containsKey(TP_TAXONOMY_ID) && map2.containsKey(TP_TAXONOMY_ID_PROVIDER)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(map2.get(TP_TAXONOMY_ID), map2.get(TP_TAXONOMY_ID_PROVIDER)));
                } else if (map2.containsKey(TP_TAXONOMY_ID)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(map2.get(TP_TAXONOMY_ID)));
                }
                if (map2.containsKey(TP_TAXONOMY_SN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setScientificName(map2.get(TP_TAXONOMY_SN));
                }
                if (map2.containsKey(TP_TAXONOMY_CN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setCommonName(map2.get(TP_TAXONOMY_CN));
                }
                if (map2.containsKey(TP_TAXONOMY_SYN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().getSynonyms().add(map2.get(TP_TAXONOMY_SYN));
                }
                if (map2.containsKey(TP_SEQ_ACCESSION) && map2.containsKey(TP_SEQ_ACCESSION_SOURCE)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setAccession(new Accession(map2.get(TP_SEQ_ACCESSION), map2.get(TP_SEQ_ACCESSION_SOURCE)));
                }
                if (map2.containsKey(TP_SEQ_ANNOTATION_DESC)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    annotation = new Annotation();
                    annotation.setDesc(map2.get(TP_SEQ_ANNOTATION_DESC));
                    phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                }
                if (map2.containsKey(TP_SEQ_ANNOTATION_REF)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    annotation = new Annotation(map2.get(TP_SEQ_ANNOTATION_REF));
                    phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                }
                if (map2.containsKey(TP_SEQ_SYMBOL)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setSymbol(map2.get(TP_SEQ_SYMBOL));
                }
                if (map2.containsKey(TP_SEQ_NAME)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setName(map2.get(TP_SEQ_NAME));
                }
                if (map2.containsKey(TP_SEQ_MOL_SEQ)) {
                    ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setMolecularSequence(map2.get(TP_SEQ_MOL_SEQ));
                }
                if (!map2.containsKey(TP_NODE_NAME)) continue;
                phylogenyNode.setName(map2.get(TP_NODE_NAME));
                continue;
            }
            if (!bl) continue;
            throw new IllegalArgumentException("\"" + string + "\" not found in name map");
        }
    }

    public static String decorate(Phylogeny phylogeny, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        return PhylogenyDecorator.decorate(phylogeny, map, fIELD, bl, bl2, bl3, null, bl4, bl5, bl6);
    }

    public static String decorate(Phylogeny phylogeny, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, boolean bl3, Map<String, String> map2, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException, PhyloXmlDataFormatException {
        if (bl && fIELD == FIELD.TAXONOMY_SCIENTIFIC_NAME) {
            throw new IllegalArgumentException("attempt to extract bracketed scientific name together with data field pointing to scientific name");
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("map is empty");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        block9: while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) {
                ++n;
            } else {
                ++n3;
            }
            String string = phylogenyNode.getName();
            if (bl3 && phylogenyNode.isExternal() && ForesterUtil.isEmpty(string)) {
                throw new IllegalArgumentException("external node with no name present");
            }
            String string2 = null;
            String string3 = string;
            if (bl5 && string.indexOf(126) > 0) {
                int n5 = string.indexOf(126);
                string2 = string.substring(n5);
                string = string.substring(0, n5);
                if (phylogenyNode.isExternal() && ForesterUtil.isEmpty(string)) {
                    throw new IllegalArgumentException("external node with illegal name: " + string3);
                }
            }
            if (ForesterUtil.isEmpty(string)) continue;
            if (map2 != null) {
                string = PhylogenyDecorator.extractIntermediate(map2, string, bl6);
            }
            if (fIELD == FIELD.MOL_SEQ && !map.containsKey(string)) {
                string = string3;
            }
            if (map.containsKey(string)) {
                String string4 = map.get(string).trim().replaceAll("/\\s+/", " ");
                if (!ForesterUtil.isEmpty(string4)) {
                    if (phylogenyNode.isExternal()) {
                        ++n2;
                    } else {
                        ++n4;
                    }
                    if (bl && string4.endsWith("]")) {
                        string4 = PhylogenyDecorator.extractBracketedScientificNames(phylogenyNode, string4);
                    } else if (bl2) {
                        if (ParserUtils.TAXOMONY_CODE_PATTERN_BRACKETED.matcher(string4).find()) {
                            string4 = PhylogenyDecorator.extractBracketedTaxCodes(phylogenyNode, string4);
                        } else if (bl3) {
                            throw new IllegalArgumentException(" could not get taxonomy from \"" + string4 + "\"");
                        }
                    }
                    switch (fIELD) {
                        case MOL_SEQ: {
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            if (!phylogenyNode.getNodeData().isHasSequence()) {
                                phylogenyNode.getNodeData().setSequence(new Sequence());
                            }
                            phylogenyNode.getNodeData().getSequence().setMolecularSequence(string4);
                            MolecularSequence.TYPE tYPE = ForesterUtil.guessMolecularSequenceType(string4);
                            if (tYPE == null) continue block9;
                            if (tYPE == MolecularSequence.TYPE.AA) {
                                phylogenyNode.getNodeData().getSequence().setType("protein");
                                continue block9;
                            }
                            if (tYPE == MolecularSequence.TYPE.DNA) {
                                phylogenyNode.getNodeData().getSequence().setType("dna");
                                continue block9;
                            }
                            if (tYPE != MolecularSequence.TYPE.RNA) continue block9;
                            phylogenyNode.getNodeData().getSequence().setType("rna");
                            continue block9;
                        }
                        case SEQUENCE_ANNOTATION_DESC: {
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            if (!phylogenyNode.getNodeData().isHasSequence()) {
                                phylogenyNode.getNodeData().setSequence(new Sequence());
                            }
                            Annotation annotation = new Annotation();
                            annotation.setDesc(string4);
                            phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                            continue block9;
                        }
                        case DOMAIN_STRUCTURE: {
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            if (!phylogenyNode.getNodeData().isHasSequence()) {
                                phylogenyNode.getNodeData().setSequence(new Sequence());
                            }
                            phylogenyNode.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(string4));
                            continue block9;
                        }
                        case TAXONOMY_CODE: {
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                            phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string4);
                            continue block9;
                        }
                        case TAXONOMY_SCIENTIFIC_NAME: {
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                            phylogenyNode.getNodeData().getTaxonomy().setScientificName(string4);
                            continue block9;
                        }
                        case SEQUENCE_NAME: {
                            if (bl5) {
                                string4 = PhylogenyDecorator.addTildeAnnotation(string2, string4);
                            }
                            if (bl6) {
                                System.out.println(string + ": " + string4);
                            }
                            if (!phylogenyNode.getNodeData().isHasSequence()) {
                                phylogenyNode.getNodeData().setSequence(new Sequence());
                            }
                            phylogenyNode.getNodeData().getSequence().setName(string4);
                            continue block9;
                        }
                        case NODE_NAME: {
                            if (bl6) {
                                System.out.print(string + " -> ");
                            }
                            if (bl4) {
                                if (bl6) {
                                    System.out.print(string4 + " -> ");
                                }
                                string4 = PhylogenyDecorator.deleteAtFirstSpace(string4);
                            }
                            if (bl5) {
                                string4 = PhylogenyDecorator.addTildeAnnotation(string2, string4);
                            }
                            if (bl6) {
                                System.out.println(string4);
                            }
                            phylogenyNode.setName(string4);
                            continue block9;
                        }
                        default: {
                            throw new RuntimeException("unknown field \"" + (Object)((Object)fIELD) + "\"");
                        }
                    }
                }
                throw new IllegalArgumentException("node name \"" + string + "\" maps to empty value");
            }
            if (!bl3 || !phylogenyNode.isExternal()) continue;
            throw new IllegalArgumentException("node name \"" + string + "\" not found in map");
        }
        return "updated " + n2 + "/" + n + " external nodes, updated " + n4 + "/" + n3 + " internal nodes";
    }

    public static Map<String, Map<String, String>> parseMappingTable(File file) throws IOException {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        BasicTable<String> basicTable = null;
        basicTable = BasicTableParser.parse(file, '\t', false, false);
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            String string = null;
            for (int j = 0; j < basicTable.getNumberOfColumns(); ++j) {
                String string2 = basicTable.getValue(j, i);
                if (j == 0) {
                    string = string2;
                    continue;
                }
                if (string2 == null) continue;
                String string3 = string2.substring(0, string2.indexOf(58));
                String string4 = string2.substring(string2.indexOf(58) + 1, string2.length());
                hashMap2.put(string3, string4);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private static final String addTildeAnnotation(String string, String string2) {
        if (ForesterUtil.isEmpty(string)) {
            return string2;
        }
        return string2 + string;
    }

    private static String deleteAtFirstSpace(String string) {
        int n = string.indexOf(" ");
        if (n > 1) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    private static String extractBracketedScientificNames(PhylogenyNode phylogenyNode, String string) {
        int n = string.lastIndexOf("[");
        String string2 = string.substring(n + 1, string.length() - 1);
        ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string2);
        return string.substring(0, n - 1).trim();
    }

    private static String extractBracketedTaxCodes(PhylogenyNode phylogenyNode, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        String string2 = PhylogenyDecorator.extractBracketedTaxCodes(stringBuilder);
        if (!ForesterUtil.isEmpty(string2)) {
            ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
            try {
                phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string2);
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                throw new IllegalArgumentException("illegal format for taxonomy code: " + string2);
            }
            return stringBuilder.toString().trim();
        }
        return string;
    }

    private static String extractBracketedTaxCodes(StringBuilder stringBuilder) {
        Matcher matcher = ParserUtils.TAXOMONY_CODE_PATTERN_BRACKETED.matcher(stringBuilder);
        if (matcher.find()) {
            String string = matcher.group(1);
            stringBuilder.delete(matcher.start(1) - 1, matcher.end(1) + 1);
            return string;
        }
        return null;
    }

    private static String extractIntermediate(Map<String, String> map, String string, boolean bl) {
        String string2 = null;
        if (bl) {
            System.out.print(string + " => ");
        }
        if (map.containsKey(string)) {
            string2 = map.get(string);
            if (ForesterUtil.isEmpty(string2)) {
                throw new IllegalArgumentException("\"" + string + "\" maps to null or empty string in secondary map");
            }
        } else {
            throw new IllegalArgumentException("\"" + string + "\" not found in name secondary map");
        }
        if (bl) {
            System.out.println(string2 + "  ");
        }
        return string2;
    }

    public static enum FIELD {
        DOMAIN_STRUCTURE,
        MOL_SEQ,
        NODE_NAME,
        SEQUENCE_ANNOTATION_DESC,
        SEQUENCE_NAME,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME;

    }
}

