/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.AdjactantDirectedCombinableDomains;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicGenomeWideCombinableDomains
implements GenomeWideCombinableDomains {
    private static final Comparator<CombinableDomains> DESCENDING_COMBINATIONS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getNumberOfCombinableDomains() < combinableDomains2.getNumberOfCombinableDomains()) {
                return 1;
            }
            if (combinableDomains.getNumberOfCombinableDomains() > combinableDomains2.getNumberOfCombinableDomains()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().compareTo(combinableDomains2.getKeyDomain());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getKeyDomainCount() < combinableDomains2.getKeyDomainCount()) {
                return 1;
            }
            if (combinableDomains.getKeyDomainCount() > combinableDomains2.getKeyDomainCount()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().compareTo(combinableDomains2.getKeyDomain());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getKeyDomainProteinsCount() < combinableDomains2.getKeyDomainProteinsCount()) {
                return 1;
            }
            if (combinableDomains.getKeyDomainProteinsCount() > combinableDomains2.getKeyDomainProteinsCount()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().compareTo(combinableDomains2.getKeyDomain());
        }
    };
    private final SortedMap<String, CombinableDomains> _combinable_domains_map = new TreeMap<String, CombinableDomains>();
    private final BinaryDomainCombination.DomainCombinationType _dc_type;
    private final Species _species;

    private BasicGenomeWideCombinableDomains(Species species, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        this._species = species;
        this._dc_type = domainCombinationType;
    }

    @Override
    public boolean contains(String string) {
        return this._combinable_domains_map.containsKey(string);
    }

    @Override
    public CombinableDomains get(String string) {
        return (CombinableDomains)this._combinable_domains_map.get(string);
    }

    @Override
    public SortedMap<String, CombinableDomains> getAllCombinableDomainsIds() {
        return this._combinable_domains_map;
    }

    @Override
    public SortedSet<String> getAllDomainIds() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(string);
            List<String> list = combinableDomains.getAllDomains();
            for (String string2 : list) {
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    @Override
    public BinaryDomainCombination.DomainCombinationType getDomainCombinationType() {
        return this._dc_type;
    }

    @Override
    public SortedSet<String> getMostPromiscuosDomain() {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = (int)this.getPerGenomeDomainPromiscuityStatistics().getMax();
        for (String string : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(string);
            if (combinableDomains.getNumberOfCombinableDomains() != n) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    @Override
    public DescriptiveStatistics getPerGenomeDomainPromiscuityStatistics() {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (String string : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(string);
            basicDescriptiveStatistics.addValue(combinableDomains.getNumberOfCombinableDomains());
        }
        return basicDescriptiveStatistics;
    }

    @Override
    public int getSize() {
        return this._combinable_domains_map.size();
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public SortedSet<BinaryDomainCombination> toBinaryDomainCombinations() {
        TreeSet<BinaryDomainCombination> treeSet = new TreeSet<BinaryDomainCombination>();
        for (String string : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(string);
            for (BinaryDomainCombination binaryDomainCombination : combinableDomains.toBinaryDomainCombinations()) {
                treeSet.add(binaryDomainCombination);
            }
        }
        return treeSet;
    }

    public String toString() {
        return this.toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID).toString();
    }

    @Override
    public StringBuilder toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<CombinableDomains> arrayList = new ArrayList<CombinableDomains>();
        for (String object : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(object);
            arrayList.add(combinableDomains);
        }
        if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT) {
            Collections.sort(arrayList, DESCENDING_KEY_DOMAIN_COUNT_ORDER);
        } else if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT) {
            Collections.sort(arrayList, DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER);
        } else if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT) {
            Collections.sort(arrayList, DESCENDING_COMBINATIONS_COUNT_ORDER);
        }
        for (CombinableDomains combinableDomains : arrayList) {
            stringBuilder.append(ForesterUtil.pad(new StringBuffer(combinableDomains.getKeyDomain().toString()), 18, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getKeyDomainCount()), 8, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getKeyDomainProteinsCount()), 8, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getNumberOfCombinableDomains()), 8, ' ', false));
            stringBuilder.append((CharSequence)combinableDomains.getCombiningDomainIdsAsStringBuilder());
            stringBuilder.append(ForesterUtil.getLineSeparator());
        }
        return stringBuilder;
    }

    private void add(String string, CombinableDomains combinableDomains) {
        this._combinable_domains_map.put(string, combinableDomains);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species) {
        return BasicGenomeWideCombinableDomains.createInstance(list, bl, species, null, BinaryDomainCombination.DomainCombinationType.BASIC, null, null);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        return BasicGenomeWideCombinableDomains.createInstance(list, bl, species, null, domainCombinationType, null, null);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species, Map<String, List<GoId>> map, BinaryDomainCombination.DomainCombinationType domainCombinationType, Map<String, DescriptiveStatistics> map2, Map<String, DescriptiveStatistics> map3) {
        BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = new BasicGenomeWideCombinableDomains(species, domainCombinationType);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Protein object : list) {
            if (!object.getSpecies().equals(species)) {
                throw new IllegalArgumentException("species (" + object.getSpecies() + ") does not match species of combinable domains collection (" + species + ")");
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < object.getProteinDomains().size(); ++i) {
                String string;
                BinaryDomainCombination binaryDomainCombination;
                Iterator<BinaryDomainCombination> iterator;
                Domain domain = object.getProteinDomain(i);
                String string2 = domain.getDomainId();
                int n = domain.getFrom();
                BasicGenomeWideCombinableDomains.countDomains(hashMap, hashSet2, string2);
                if (hashSet.contains(string2)) continue;
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.BASIC) {
                    hashSet.add(string2);
                }
                CombinableDomains combinableDomains = null;
                if (basicGenomeWideCombinableDomains.contains(string2)) {
                    combinableDomains = basicGenomeWideCombinableDomains.get(string2);
                } else {
                    combinableDomains = domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? new AdjactantDirectedCombinableDomains(domain.getDomainId(), species) : (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED ? new DirectedCombinableDomains(domain.getDomainId(), species) : new BasicCombinableDomains(domain.getDomainId(), species));
                    basicGenomeWideCombinableDomains.add(string2, combinableDomains);
                }
                combinableDomains.addKeyDomainProtein(object.getProteinId().getId());
                HashSet<Object> hashSet3 = new HashSet<Object>();
                if (bl) {
                    hashSet3.add(string2);
                }
                Domain domain2 = null;
                for (int list3 = 0; list3 < object.getNumberOfProteinDomains(); ++list3) {
                    if (domainCombinationType != BinaryDomainCombination.DomainCombinationType.BASIC && n >= object.getProteinDomain(list3).getFrom() || i == list3 || hashSet3.contains(iterator = object.getProteinDomain(list3).getDomainId())) continue;
                    hashSet3.add(iterator);
                    if (domainCombinationType != BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                        combinableDomains.addCombinableDomain(object.getProteinDomain(list3).getDomainId());
                        continue;
                    }
                    if (domain2 == null) {
                        domain2 = object.getProteinDomain(list3);
                        continue;
                    }
                    if (object.getProteinDomain(list3).getFrom() >= domain2.getFrom()) continue;
                    domain2 = object.getProteinDomain(list3);
                }
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT && domain2 != null) {
                    combinableDomains.addCombinableDomain(domain2.getDomainId());
                }
                if (map2 != null) {
                    List<BinaryDomainCombination> list2 = combinableDomains.toBinaryDomainCombinations();
                    iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        binaryDomainCombination = iterator.next();
                        string = binaryDomainCombination.toString();
                        if (!map2.containsKey(string)) {
                            map2.put(string, new BasicDescriptiveStatistics());
                        }
                        map2.get(string).addValue(object.getLength());
                    }
                }
                if (map3 == null) continue;
                List<BinaryDomainCombination> list3 = combinableDomains.toBinaryDomainCombinations();
                iterator = list3.iterator();
                while (iterator.hasNext()) {
                    binaryDomainCombination = iterator.next();
                    string = binaryDomainCombination.toString();
                    if (!map3.containsKey(string)) {
                        map3.put(string, new BasicDescriptiveStatistics());
                    }
                    map3.get(string).addValue(object.getNumberOfProteinDomains());
                }
            }
        }
        for (String string : hashMap.keySet()) {
            basicGenomeWideCombinableDomains.get(string).setKeyDomainCount((Integer)hashMap.get(string));
        }
        return basicGenomeWideCombinableDomains;
    }

    private static void countDomains(Map<String, Integer> map, Set<String> set, String string) {
        if (map.containsKey(string)) {
            map.put(string, 1 + map.get(string));
        } else {
            map.put(string, 1);
        }
        set.add(string);
    }
}

