/*
 * Decompiled with CFR 0.152.
 */
package org.forester.rio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.rio.RIO;
import org.forester.rio.RIOException;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public final class RIOUtil {
    public static final String STRIPPED_SPECIES_TREE_SUFFIX = "_RIO_stripped_species_tree.xml";
    public static final String ORTHO_OUTTABLE_SUFFIX = "_RIO_orthologies.tsv";
    public static final String ORTHO_OUTTABLE_WITH_MAP_SUFFIX = "_RIO_orthologies_ext_map.tsv";
    public static final String OUT_MIN_DUP_GENE_TREE_SUFFIX = "_RIO_gene_tree_min_dup_";
    public static final String OUT_MED_DUP_GENE_TREE_SUFFIX = "_RIO_gene_tree_med_dup_";
    public static final String BEST_TREE_SUFFIX = "_RIO_consensus_gene_tree_dup_";
    public static final String ORTHOLOG_GROUPS_SUFFIX = "_RIO_ortholog_groups.tsv";
    public static final String LOGFILE_SUFFIX = "_RIO_log.tsv";

    public static final void executeAnalysis(File file, File file2, File file3, File file4, File file5, File file6, String string, RIO.REROOTING rEROOTING, int n, int n2, File file7, File file8, File file9, boolean bl, SDIutil.ALGORITHM aLGORITHM, boolean bl2, EasyWriter easyWriter, double d, boolean bl3, File file10, String string2, boolean bl4, File file11, File file12, String string3) {
        try {
            int n3;
            Object object;
            RIO rIO;
            SortedMap<String, String> sortedMap = bl3 ? RIOUtil.obtainMapping(file10, file.getName(), string2) : null;
            boolean bl5 = false;
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            if (phylogenyParser instanceof PhyloXmlParser) {
                rIO = RIO.executeAnalysis(file, file2, aLGORITHM, rEROOTING, string, n, n2, file6 != null, true, bl);
            } else {
                bl5 = true;
                if (phylogenyParser instanceof NHXParser) {
                    object = (NHXParser)phylogenyParser;
                    ((NHXParser)object).setReplaceUnderscores(false);
                    ((NHXParser)object).setIgnoreQuotes(true);
                    ((NHXParser)object).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else if (phylogenyParser instanceof NexusPhylogeniesParser) {
                    object = (NexusPhylogeniesParser)phylogenyParser;
                    ((NexusPhylogeniesParser)object).setReplaceUnderscores(false);
                    ((NexusPhylogeniesParser)object).setIgnoreQuotes(true);
                    ((NexusPhylogeniesParser)object).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else {
                    throw new RuntimeException("unknown parser type: " + phylogenyParser);
                }
                object = (IteratingPhylogenyParser)((Object)phylogenyParser);
                object.setSource(file);
                rIO = RIO.executeAnalysis((IteratingPhylogenyParser)object, file2, aLGORITHM, rEROOTING, string, n, n2, file6 != null, !bl2, bl);
            }
            if (!bl2 && aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                System.out.println("Taxonomy linking based on           :\t" + (Object)((Object)rIO.getGSDIRtaxCompBase()));
            }
            object = bl5 ? rIO.getOrthologTable() : RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            GSDIR gSDIR = bl4 ? RIOUtil.analyzeConsensusTree(file, file2, file11, file12, sortedMap, string3) : null;
            BasicDescriptiveStatistics basicDescriptiveStatistics = rIO.getDuplicationsStatistics();
            if (bl3) {
                RIOUtil.writeOrthologyTable(file3, basicDescriptiveStatistics.getN(), (IntMatrix)object, !bl2, sortedMap, true);
                RIOUtil.writeOrthologyTable(file4, basicDescriptiveStatistics.getN(), (IntMatrix)object, !bl2, sortedMap, false);
            } else {
                RIOUtil.writeOrthologyTable(file3, basicDescriptiveStatistics.getN(), (IntMatrix)object, !bl2, null, false);
            }
            int n4 = RIOUtil.writeOrtologGroups(file5, d, basicDescriptiveStatistics.getN(), (IntMatrix)object, !bl2, false, sortedMap);
            int n5 = RIOUtil.writeOrtologGroups(null, 0.05, basicDescriptiveStatistics.getN(), (IntMatrix)object, false, true, null);
            int n6 = RIOUtil.writeOrtologGroups(null, 0.25, basicDescriptiveStatistics.getN(), (IntMatrix)object, false, true, null);
            int n7 = RIOUtil.writeOrtologGroups(null, 0.5, basicDescriptiveStatistics.getN(), (IntMatrix)object, false, true, null);
            int n8 = RIOUtil.writeOrtologGroups(null, 0.75, basicDescriptiveStatistics.getN(), (IntMatrix)object, false, true, null);
            int n9 = RIOUtil.writeOrtologGroups(null, 0.95, basicDescriptiveStatistics.getN(), (IntMatrix)object, false, true, null);
            if (aLGORITHM != SDIutil.ALGORITHM.SDIR && file6 != null) {
                RIOUtil.writeLogFile(file6, rIO, file2, file, file3, "rio", "5.900", "170420", ForesterUtil.getForesterLibraryInformation(), !bl2);
            }
            if (file7 != null) {
                RIOUtil.writeTree(rIO.getSpeciesTree(), file7, bl2 ? null : "Wrote (stripped) species tree to    :\t", null);
            }
            if (file8 != null && rIO.getMinDuplicationsGeneTree() != null) {
                n3 = (int)rIO.getDuplicationsStatistics().getMin();
                RIOUtil.writeTree(rIO.getMinDuplicationsGeneTree(), new File(file8.toString() + n3 + ".xml"), bl2 ? null : "Wrote one min duplication gene tree :\t", sortedMap);
            }
            if (file9 != null && rIO.getDuplicationsToTreeMap() != null) {
                n3 = (int)rIO.getDuplicationsStatistics().median();
                RIOUtil.writeTree(rIO.getDuplicationsToTreeMap().get(n3), new File(file9.toString() + n3 + ".xml"), bl2 ? null : "Wrote one med duplication gene tree :\t", sortedMap);
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.##");
            int n10 = (int)basicDescriptiveStatistics.getMin();
            int n11 = (int)basicDescriptiveStatistics.getMax();
            int n12 = (int)basicDescriptiveStatistics.median();
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            for (double d2 : basicDescriptiveStatistics.getData()) {
                if ((int)d2 == n10) {
                    ++n13;
                }
                if ((int)d2 == n11) {
                    ++n14;
                }
                if ((int)d2 != n12) continue;
                ++n15;
            }
            double d3 = 100.0 * (double)n13 / (double)basicDescriptiveStatistics.getN();
            double d4 = 100.0 * (double)n14 / (double)basicDescriptiveStatistics.getN();
            double d5 = 100.0 * (double)n15 / (double)basicDescriptiveStatistics.getN();
            if (bl2) {
                String string4 = file.getName();
                if (string4.indexOf(".") > 0) {
                    string4 = string4.substring(0, string4.lastIndexOf("."));
                }
                easyWriter.print(string4);
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(rIO.getExtNodesOfAnalyzedGeneTrees()));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n4));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n5));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n6));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n7));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n8));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n9));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(gSDIR.getMinDuplicationsSum()));
                easyWriter.print("\t");
                easyWriter.print(decimalFormat.format(n12 - gSDIR.getMinDuplicationsSum()));
                easyWriter.print("\t");
                if (basicDescriptiveStatistics.getN() > 3) {
                    easyWriter.print(decimalFormat.format(n12));
                } else {
                    easyWriter.print("");
                }
                easyWriter.print("\t");
                easyWriter.print(decimalFormat.format(basicDescriptiveStatistics.arithmeticMean()));
                easyWriter.print("\t");
                if (basicDescriptiveStatistics.getN() > 3) {
                    easyWriter.print(decimalFormat.format(basicDescriptiveStatistics.sampleStandardDeviation()));
                } else {
                    easyWriter.print("");
                }
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n10));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(n11));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(rIO.getRemovedGeneTreeNodes().size()));
                easyWriter.print("\t");
                easyWriter.print(Integer.toString(basicDescriptiveStatistics.getN()));
                easyWriter.println();
            } else {
                System.out.println("Gene tree internal nodes            :\t" + rIO.getIntNodesOfAnalyzedGeneTrees());
                System.out.println("Gene tree external nodes            :\t" + rIO.getExtNodesOfAnalyzedGeneTrees());
                System.out.println("Mean number of duplications         :\t" + decimalFormat.format(basicDescriptiveStatistics.arithmeticMean()) + "\t" + decimalFormat.format(100.0 * basicDescriptiveStatistics.arithmeticMean() / (double)rIO.getIntNodesOfAnalyzedGeneTrees()) + "%\t(sd: " + decimalFormat.format(basicDescriptiveStatistics.sampleStandardDeviation()) + ")");
                if (basicDescriptiveStatistics.getN() > 3) {
                    System.out.println("Median number of duplications       :\t" + decimalFormat.format(n12) + "\t" + decimalFormat.format(100.0 * (double)n12 / (double)rIO.getIntNodesOfAnalyzedGeneTrees()) + "%");
                }
                System.out.println("Minimum duplications                :\t" + n10 + "\t" + decimalFormat.format(100.0 * (double)n10 / (double)rIO.getIntNodesOfAnalyzedGeneTrees()) + "%");
                System.out.println("Maximum duplications                :\t" + n11 + "\t" + decimalFormat.format(100.0 * (double)n11 / (double)rIO.getIntNodesOfAnalyzedGeneTrees()) + "%");
                System.out.println("Gene trees with median duplications :\t" + n15 + "\t" + decimalFormat.format(d5) + "%");
                System.out.println("Gene trees with minimum duplications:\t" + n13 + "\t" + decimalFormat.format(d3) + "%");
                System.out.println("Gene trees with maximum duplications:\t" + n14 + "\t" + decimalFormat.format(d4) + "%");
                if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                    System.out.println("Removed ext gene tree nodes         :\t" + rIO.getRemovedGeneTreeNodes().size());
                }
            }
        }
        catch (RIOException rIOException) {
            ForesterUtil.fatalError(rIOException.getLocalizedMessage());
        }
        catch (SDIException sDIException) {
            ForesterUtil.fatalError(sDIException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(iOException.getLocalizedMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ForesterUtil.outOfMemoryError(outOfMemoryError);
        }
        catch (Exception exception) {
            ForesterUtil.unexpectedFatalError(exception);
        }
        catch (Error error) {
            ForesterUtil.unexpectedFatalError(error);
        }
    }

    private static final GSDIR analyzeConsensusTree(File file, File file2, File file3, File file4, SortedMap<String, String> sortedMap, String string) throws IOException, FileNotFoundException, PhyloXmlDataFormatException, SDIException {
        Object object;
        Object object2;
        File file5 = ForesterUtil.getMatchingFile(file4, file.getName(), string);
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny phylogeny = phylogenyFactory.create(file5, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
        Phylogeny phylogeny2 = SDIutil.parseSpeciesTree(phylogeny, file2, false, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        PhylogenyMethods.deleteInternalNodesWithOnlyOneDescendent(phylogeny2);
        phylogeny.setRooted(true);
        phylogeny2.setRooted(true);
        if (!phylogeny.isCompletelyBinaryAllow3ChildrenAtRoot()) {
            throw new IOException("gene tree matching to [" + ForesterUtil.removeFileExtension(file.getName()) + "] is not completely binary");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            object2 = phylogenyNodeIterator.next();
            object = ((PhylogenyNode)object2).getName().trim();
            if (ForesterUtil.isEmpty((String)object)) continue;
            try {
                ParserUtils.extractTaxonomyDataFromNodeName((PhylogenyNode)object2, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {}
        }
        object2 = new GSDIR(phylogeny, phylogeny2, true, true, true);
        object = ((GSDIR)object2).getMinDuplicationsSumGeneTree();
        ((Phylogeny)object).setRerootable(false);
        PhylogenyMethods.orderAppearance(((Phylogeny)object).getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        String string2 = ForesterUtil.removeFileExtension(file5.getName());
        File file6 = new File(file3.getCanonicalFile() + "/" + string2 + BEST_TREE_SUFFIX + ((GSDIR)object2).getMinDuplicationsSum() + ".xml");
        RIOUtil.writeTree((Phylogeny)object, file6, null, sortedMap);
        return object2;
    }

    private static final void writeOrthologyTable(File file, int n, IntMatrix intMatrix, boolean bl, SortedMap<String, String> sortedMap, boolean bl2) throws IOException {
        int n2;
        EasyWriter easyWriter = ForesterUtil.createEasyWriter(file);
        DecimalFormat decimalFormat = new DecimalFormat("0.####");
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        for (n2 = 0; n2 < intMatrix.size(); ++n2) {
            easyWriter.print("\t");
            if (bl2) {
                if (!sortedMap.containsKey(intMatrix.getLabel(n2))) {
                    throw new IOException("no id mapping for \"" + intMatrix.getLabel(n2) + "\" (attempting to write [" + file + "])");
                }
                easyWriter.print((String)sortedMap.get(intMatrix.getLabel(n2)));
                continue;
            }
            easyWriter.print(intMatrix.getLabel(n2));
        }
        easyWriter.println();
        for (n2 = 0; n2 < intMatrix.size(); ++n2) {
            if (bl2) {
                easyWriter.print((String)sortedMap.get(intMatrix.getLabel(n2)));
            } else {
                easyWriter.print(intMatrix.getLabel(n2));
            }
            for (int i = 0; i < intMatrix.size(); ++i) {
                easyWriter.print("\t");
                if (n2 == i) {
                    if (intMatrix.get(n2, i) != n) {
                        ForesterUtil.unexpectedFatalError("diagonal value is off");
                    }
                    easyWriter.print("-");
                    continue;
                }
                easyWriter.print(decimalFormat.format((double)intMatrix.get(n2, i) / (double)n));
            }
            easyWriter.println();
        }
        if (!bl2 && sortedMap != null && sortedMap.size() > 0) {
            easyWriter.println();
            for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
                easyWriter.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
        easyWriter.close();
        if (bl) {
            System.out.println("Wrote table to                      :\t" + file.getCanonicalPath());
        }
    }

    private static final int writeOrtologGroups(File file, double d, int n, IntMatrix intMatrix, boolean bl, boolean bl2, SortedMap<String, String> sortedMap) throws IOException {
        Object object;
        int n2;
        Object object2;
        int n3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 1; n3 < intMatrix.size(); ++n3) {
            object2 = intMatrix.getLabel(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                object = intMatrix.getLabel(n2);
                double d2 = (double)intMatrix.get(n3, n2) / (double)n;
                basicDescriptiveStatistics.addValue(d2);
                if (d2 < 0.75) {
                    ++n4;
                    if (d2 < 0.5) {
                        ++n5;
                        if (d2 < 0.25) {
                            ++n6;
                        }
                    }
                }
                if (!(d2 >= d)) continue;
                boolean bl3 = false;
                for (SortedSet sortedSet : arrayList) {
                    if (sortedSet.contains(object2)) {
                        sortedSet.add(object);
                        bl3 = true;
                    }
                    if (!sortedSet.contains(object)) continue;
                    sortedSet.add(object2);
                    bl3 = true;
                }
                if (bl3) continue;
                TreeSet treeSet = new TreeSet();
                treeSet.add(object2);
                treeSet.add(object);
                arrayList.add(treeSet);
            }
        }
        for (n3 = 0; n3 < intMatrix.size(); ++n3) {
            object2 = intMatrix.getLabel(n3);
            n2 = 0;
            for (SortedSet sortedSet : arrayList) {
                if (!sortedSet.contains(object2)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            object = new TreeSet<Object>();
            object.add(object2);
            arrayList.add(object);
        }
        if (bl2) {
            return arrayList.size();
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.####");
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        object2 = ForesterUtil.createEasyWriter(file);
        n2 = 1;
        for (SortedSet sortedSet : arrayList) {
            ((EasyWriter)object2).print(Integer.toString(n2++));
            for (String string : sortedSet) {
                ((EasyWriter)object2).print("\t");
                if (sortedMap != null && sortedMap.size() > 0) {
                    if (!sortedMap.containsKey(string)) {
                        throw new IOException("no id mapping for \"" + string + "\" (attempting to write [" + file + "])");
                    }
                    ((EasyWriter)object2).print((String)sortedMap.get(string));
                    continue;
                }
                ((EasyWriter)object2).print(string);
            }
            ((EasyWriter)object2).println();
        }
        ((EasyWriter)object2).println();
        ((EasyWriter)object2).println("# Cutoff\t" + decimalFormat.format(d));
        ((EasyWriter)object2).println();
        ((EasyWriter)object2).println("# Orthology support statistics:");
        if (basicDescriptiveStatistics.getN() > 3) {
            ((EasyWriter)object2).println("# Median\t" + decimalFormat.format(basicDescriptiveStatistics.median()));
        }
        ((EasyWriter)object2).println("# Mean\t" + decimalFormat.format(basicDescriptiveStatistics.arithmeticMean()));
        if (basicDescriptiveStatistics.getN() > 3) {
            ((EasyWriter)object2).println("# SD\t" + decimalFormat.format(basicDescriptiveStatistics.sampleStandardDeviation()));
        }
        ((EasyWriter)object2).println("# Min\t" + decimalFormat.format(basicDescriptiveStatistics.getMin()));
        ((EasyWriter)object2).println("# Max\t" + decimalFormat.format(basicDescriptiveStatistics.getMax()));
        ((EasyWriter)object2).println("# Total\t" + decimalFormat.format(basicDescriptiveStatistics.getN()));
        ((EasyWriter)object2).println("# Below 0.75\t" + n4 + "\t" + decimalFormat.format(100.0 * (double)n4 / (double)basicDescriptiveStatistics.getN()) + "%");
        ((EasyWriter)object2).println("# Below 0.5\t" + n5 + "\t" + decimalFormat.format(100.0 * (double)n5 / (double)basicDescriptiveStatistics.getN()) + "%");
        ((EasyWriter)object2).println("# Below 0.25\t" + n6 + "\t" + decimalFormat.format(100.0 * (double)n6 / (double)basicDescriptiveStatistics.getN()) + "%");
        ((BufferedWriter)object2).close();
        if (bl) {
            System.out.println("Number of ortholog groups           :\t" + arrayList.size());
            System.out.println("Wrote orthologs groups table to     :\t" + file.getCanonicalPath());
        }
        return arrayList.size();
    }

    private static void writeTree(Phylogeny phylogeny, File file, String string, SortedMap<String, String> sortedMap) throws IOException {
        Object object;
        if (sortedMap != null && sortedMap.size() > 0) {
            object = phylogeny.iteratorExternalForward();
            while (object.hasNext()) {
                PhylogenyNode phylogenyNode = object.next();
                if (!sortedMap.containsKey(phylogenyNode.getName())) {
                    throw new IOException("no id mapping for \"" + phylogenyNode.getName() + "\" (attempting to write [" + file + "])");
                }
                Sequence sequence = new Sequence();
                sequence.setName((String)sortedMap.get(phylogenyNode.getName()));
                phylogenyNode.getNodeData().addSequence(sequence);
            }
        }
        object = new PhylogenyWriter();
        ((PhylogenyWriter)object).toPhyloXML(file, phylogeny, 0);
        if (string != null) {
            System.out.println(string + file.getCanonicalPath());
        }
    }

    private static void writeLogFile(File file, RIO rIO, File file2, File file3, File file4, String string, String string2, String string3, String string4, boolean bl) throws IOException {
        EasyWriter easyWriter = ForesterUtil.createEasyWriter(file);
        easyWriter.println("# " + string);
        easyWriter.println("# version : " + string2);
        easyWriter.println("# date    : " + string3);
        easyWriter.println("# based on: " + string4);
        easyWriter.println("# ----------------------------------");
        easyWriter.println("Gene trees                          :\t" + file3.getCanonicalPath());
        easyWriter.println("Species tree                        :\t" + file2.getCanonicalPath());
        easyWriter.println("All vs all orthology table          :\t" + file4.getCanonicalPath());
        easyWriter.flush();
        easyWriter.println(rIO.getLog().toString());
        easyWriter.close();
        if (bl) {
            System.out.println("Wrote log to                        :\t" + file.getCanonicalPath());
        }
    }

    private static final SortedMap<String, String> obtainMapping(File file, String string, String string2) throws IOException {
        File file2 = ForesterUtil.getMatchingFile(file, string, string2);
        BasicTable<String> basicTable = BasicTableParser.parse(file2, '\t');
        return basicTable.getColumnsAsMap(0, 1);
    }
}

