/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class SequenceWriter {
    public static StringBuilder toFasta(MolecularSequence molecularSequence, int n) {
        return SequenceWriter.toFasta(molecularSequence.getIdentifier(), molecularSequence.getMolecularSequenceAsString(), n);
    }

    public static StringBuilder toFasta(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(">");
        stringBuilder.append(string);
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        if (n < 1 || n >= string2.length()) {
            stringBuilder.append(string2);
        } else {
            int n2 = string2.length() / n;
            int n3 = string2.length() - n2 * n;
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(string2, i * n, (i + 1) * n);
                if (i >= n2 - 1) continue;
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
            if (n3 > 0) {
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                stringBuilder.append(string2, n2 * n, string2.length());
            }
        }
        return stringBuilder;
    }

    public static void toFasta(MolecularSequence molecularSequence, Writer writer, int n) throws IOException {
        writer.write(">");
        writer.write(molecularSequence.getIdentifier());
        writer.write(ForesterUtil.LINE_SEPARATOR);
        if (n < 1 || n >= molecularSequence.getLength()) {
            writer.write(molecularSequence.getMolecularSequence());
        } else {
            int n2 = molecularSequence.getLength() / n;
            int n3 = molecularSequence.getLength() - n2 * n;
            for (int i = 0; i < n2; ++i) {
                writer.write(molecularSequence.getMolecularSequence(), i * n, n);
                if (i >= n2 - 1) continue;
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            if (n3 > 0) {
                writer.write(ForesterUtil.LINE_SEPARATOR);
                writer.write(molecularSequence.getMolecularSequence(), n2 * n, n3);
            }
        }
    }

    public static void writeSeqs(List<MolecularSequence> list, File file, SEQ_FORMAT sEQ_FORMAT, int n) throws IOException {
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file);
        SequenceWriter.writeSeqs(list, bufferedWriter, sEQ_FORMAT, n);
        ((Writer)bufferedWriter).close();
    }

    public static void writeSeqs(List<MolecularSequence> list, Writer writer, SEQ_FORMAT sEQ_FORMAT, int n) throws IOException {
        switch (sEQ_FORMAT) {
            case FASTA: {
                for (MolecularSequence molecularSequence : list) {
                    SequenceWriter.toFasta(molecularSequence, writer, n);
                    writer.write(ForesterUtil.LINE_SEPARATOR);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown format " + (Object)((Object)sEQ_FORMAT));
            }
        }
    }

    public static enum SEQ_FORMAT {
        FASTA;

    }
}

