/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoId;
import org.forester.go.GoRelationship;

public class BasicGoRelationship
implements GoRelationship {
    final GoRelationship.Type _type;
    final GoId _go_id;

    public BasicGoRelationship(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("unexpected format for GO relationship: " + string);
        }
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (string2.toLowerCase().equals("part_of")) {
            this._type = GoRelationship.Type.PART_OF;
        } else if (string2.toLowerCase().equals("regulates")) {
            this._type = GoRelationship.Type.REGULATES;
        } else if (string2.toLowerCase().equals("negatively_regulates")) {
            this._type = GoRelationship.Type.NEGATIVELY_REGULATES;
        } else if (string2.toLowerCase().equals("positively_regulates")) {
            this._type = GoRelationship.Type.POSITIVELY_REGULATES;
        } else if (string2.toLowerCase().equals("has_part")) {
            this._type = GoRelationship.Type.HAS_PART;
        } else if (string2.toLowerCase().equals("occurs_in")) {
            this._type = GoRelationship.Type.OCCURS_IN;
        } else if (string2.toLowerCase().equals("happens_during")) {
            this._type = GoRelationship.Type.HAPPENS_DURING;
        } else if (string2.toLowerCase().equals("ends_during")) {
            this._type = GoRelationship.Type.ENDS_DURING;
        } else {
            throw new IllegalArgumentException("unknown GO relationship type: " + string2);
        }
        this._go_id = new GoId(string3);
    }

    public BasicGoRelationship(String string, String string2) {
        if (!string.toLowerCase().equals("part_of")) {
            throw new IllegalArgumentException("unknown GO relationship type: " + string);
        }
        this._type = GoRelationship.Type.PART_OF;
        this._go_id = new GoId(string2);
    }

    public BasicGoRelationship(GoRelationship.Type type, GoId goId) {
        this._type = type;
        this._go_id = goId;
    }

    @Override
    public int compareTo(GoRelationship goRelationship) {
        return this.getGoId().compareTo(goRelationship.getGoId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go relationship equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go relationship equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getType().equals((Object)((GoRelationship)object).getType()) && this.getGoId().equals(((GoRelationship)object).getGoId());
    }

    @Override
    public GoId getGoId() {
        return this._go_id;
    }

    @Override
    public GoRelationship.Type getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case PART_OF: {
                stringBuffer.append("part_of");
                break;
            }
            case NEGATIVELY_REGULATES: {
                stringBuffer.append("negatively_regulates");
                break;
            }
            case POSITIVELY_REGULATES: {
                stringBuffer.append("positively_regulates");
                break;
            }
            case REGULATES: {
                stringBuffer.append("regulates");
                break;
            }
            case HAS_PART: {
                stringBuffer.append("has_part");
                break;
            }
            case OCCURS_IN: {
                stringBuffer.append("occurs_in");
                break;
            }
            default: {
                new IllegalStateException("unknown type: " + (Object)((Object)this.getType()));
            }
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.getGoId().toString());
        return stringBuffer.toString();
    }
}

