/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class AncestralTaxonomyInference {
    public static void inferTaxonomyFromDescendents(Phylogeny phylogeny) throws IOException, AncestralTaxonomyInferenceException {
        TaxonomyDataManager.clearCachesIfTooLarge();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(phylogenyNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void inferTaxonomyFromDescendents(PhylogenyNode phylogenyNode) throws IOException, AncestralTaxonomyInferenceException {
        void var5_10;
        int n;
        Object object;
        if (phylogenyNode.isExternal()) {
            throw new IllegalArgumentException("attempt to infer taxonomy from descendants of external node");
        }
        phylogenyNode.getNodeData().setTaxonomy(null);
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = Integer.MAX_VALUE;
        for (PhylogenyNode object32 : list) {
            Object object2;
            if (!(!object32.getNodeData().isHasTaxonomy() || !TaxonomyDataManager.isHasAppropriateId(object32.getNodeData().getTaxonomy()) && ForesterUtil.isEmpty(object32.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(object32.getNodeData().getTaxonomy().getLineage()) && ForesterUtil.isEmpty(object32.getNodeData().getTaxonomy().getTaxonomyCode()) && ForesterUtil.isEmpty(object32.getNodeData().getTaxonomy().getCommonName()))) {
                object2 = TaxonomyDataManager.obtainUniProtTaxonomy(object32.getNodeData().getTaxonomy(), null, null);
                if (object2 == null && ForesterUtil.isEmpty(object32.getNodeData().getTaxonomy().getLineage())) {
                    object = "";
                    object = !ForesterUtil.isEmpty(object32.getName()) ? "\"" + object32.getName() + "\"" : "[" + object32.getId() + "]";
                    System.out.println(object32.getNodeData().getTaxonomy().toString());
                    System.out.println(ForesterUtil.stringListToString(object32.getNodeData().getTaxonomy().getLineage(), "  >  "));
                    throw new AncestralTaxonomyInferenceException("a taxonomy for node " + (String)object + " could not be established from the database");
                }
                object = ForesterUtil.stringListToArray(object32.getNodeData().getTaxonomy().getLineage());
                if (object == null || ((String[])object).length < 1) {
                    object = ForesterUtil.stringListToArray(((UniProtTaxonomy)object2).getLineage());
                }
                if (object == null || ((String[])object).length < 1) {
                    throw new AncestralTaxonomyInferenceException("a taxonomic lineage for node \"" + object32.getNodeData().getTaxonomy().toString() + "\" could not be established");
                }
                if (((String[])object).length < n2) {
                    n2 = ((String[])object).length;
                }
                arrayList.add((String[])object);
                continue;
            }
            object2 = "";
            object2 = !ForesterUtil.isEmpty(object32.getName()) ? "\"" + object32.getName() + "\"" : "[" + object32.getId() + "]";
            throw new AncestralTaxonomyInferenceException("node " + (String)object2 + " has no or inappropriate taxonomic information");
        }
        ArrayList arrayList2 = new ArrayList();
        Object var5_6 = null;
        if (n2 > 0) {
            block3: for (int i = 0; i < n2; ++i) {
                object = ((String[])arrayList.get(0))[i];
                for (n = 1; n < arrayList.size(); ++n) {
                    if (!object.equals(((String[])arrayList.get(n))[i])) break block3;
                }
                arrayList2.add(object);
                Object object3 = object;
            }
        }
        if (arrayList2.isEmpty()) {
            boolean bl = false;
            boolean bl2 = false;
            n = 0;
            for (String[] stringArray : arrayList) {
                if (stringArray.length <= 0) continue;
                if (stringArray[0].equalsIgnoreCase("Viruses")) {
                    bl = true;
                } else if (stringArray[0].equalsIgnoreCase("cellular organisms")) {
                    bl2 = true;
                } else if (stringArray[0].equalsIgnoreCase("x")) {
                    n = 1;
                }
                if ((!bl2 || !bl) && n == 0) continue;
                break;
            }
            if (bl2 && bl || n != 0) {
                arrayList2.add("x");
                String string = "x";
            } else {
                void var9_27;
                String string = "no common lineage for:\n";
                boolean bl3 = false;
                for (String[] stringArray : arrayList) {
                    void var9_29;
                    void var10_40;
                    String string2 = (String)var9_27 + (int)var10_40 + ": ";
                    ++var10_40;
                    for (String string3 : stringArray) {
                        String string4 = (String)var9_29 + string3 + " ";
                    }
                    String string5 = (String)var9_29 + "\n";
                }
                throw new AncestralTaxonomyInferenceException((String)var9_27);
            }
        }
        Taxonomy taxonomy = new Taxonomy();
        phylogenyNode.getNodeData().setTaxonomy(taxonomy);
        taxonomy.setScientificName((String)var5_10);
        UniProtTaxonomy uniProtTaxonomy = TaxonomyDataManager.obtainUniProtTaxonomyFromLineage(arrayList2);
        if (uniProtTaxonomy != null) {
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getRank())) {
                try {
                    taxonomy.setRank(uniProtTaxonomy.getRank().toLowerCase());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    taxonomy.setRank("");
                }
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                taxonomy.setIdentifier(new Identifier(uniProtTaxonomy.getId(), "uniprot"));
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                taxonomy.setCommonName(uniProtTaxonomy.getCommonName());
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getSynonym()) && !taxonomy.getSynonyms().contains(uniProtTaxonomy.getSynonym())) {
                taxonomy.getSynonyms().add(uniProtTaxonomy.getSynonym());
            }
            if (uniProtTaxonomy.getLineage() != null) {
                taxonomy.setLineage(new ArrayList<String>());
                for (String string : uniProtTaxonomy.getLineage()) {
                    if (ForesterUtil.isEmpty(string)) continue;
                    taxonomy.getLineage().add(string);
                }
            }
        }
        if (ForesterUtil.isEmpty(taxonomy.getLineage())) {
            taxonomy.setLineage(new ArrayList<String>());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (ForesterUtil.isEmpty(string)) continue;
                taxonomy.getLineage().add(string);
            }
        }
        for (PhylogenyNode phylogenyNode2 : list) {
            if (phylogenyNode2.isExternal() || !phylogenyNode2.getNodeData().isHasTaxonomy() || !phylogenyNode2.getNodeData().getTaxonomy().isEqual(taxonomy)) continue;
            phylogenyNode2.getNodeData().setTaxonomy(null);
        }
    }
}

