/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.SimpleStrokeDefs;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.MultiScatterDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

public class MultiScatterChartRenderer
extends AbstractChartRenderer {
    protected Rectangle bounds;
    protected CoordSystem coord;
    protected MultiScatterDataModel model;
    protected RowColorModel rcm;
    protected double shapeSize = 10.0;
    private AffineTransform last = null;
    private ArrayList transformed = null;
    private boolean buffer_transform = false;

    public MultiScatterChartRenderer(CoordSystem cs, MultiScatterDataModel model) {
        super(cs, model);
        this.coord = cs;
        this.model = model;
        this.last = new AffineTransform();
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        if (this.getStopFlag()) {
            return false;
        }
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = this.model.getDataSetNumber();
        if (this.transformed == null && this.buffer_transform) {
            this.transformed = new ArrayList(datasetcount);
        }
        int set = 0;
        while (set < datasetcount) {
            if (this.getStopFlag()) break;
            if (this.transformed != null && this.transformed.size() < datasetcount && this.buffer_transform) {
                this.transformed.add(new Point2D[this.model.getDataSetLength(set)]);
            }
            if (this.model.getSeriesLine(set) && !this.getStopFlag()) {
                this.drawline(yaxis1, set, g);
            }
            if (this.model.getSeriesMarker(set) && !this.getStopFlag()) {
                this.drawmarkers(yaxis1, set, g);
            }
            ++set;
        }
        if (this.buffer_transform && !this.getStopFlag() && !yaxis1.equals(this.last)) {
            this.last = yaxis1;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }

    private void drawline(AffineTransform yaxis1, int set, Graphics2D g) {
        int value;
        Point2D paint = null;
        Point2D hold = null;
        Point2D oldpaint = null;
        boolean numericalcolumns = this.model.isColumnNumeric();
        float modelVal = 0.0f;
        Point2D[] buffer = null;
        if (this.buffer_transform) {
            buffer = (Point2D[])this.transformed.get(set);
        }
        Stroke backupStroke = g.getStroke();
        g.setStroke(SimpleStrokeDefs.getStroke(this.model.getSeriesLineStyle(set)));
        g.setColor(this.rcm.getColor(set));
        if (!yaxis1.equals(this.last) || !this.buffer_transform) {
            value = 0;
            while (value < this.model.getDataSetLength(set)) {
                modelVal = this.model.getValueAt(set, value).floatValue();
                if (modelVal != modelVal || modelVal == Float.NEGATIVE_INFINITY || modelVal == Float.POSITIVE_INFINITY) {
                    oldpaint = null;
                } else {
                    Point2D.Float val = numericalcolumns ? new Point2D.Float(((Number)this.model.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal);
                    oldpaint = paint;
                    hold = yaxis1.transform(val, null);
                    if (hold != null) {
                        paint = hold;
                        hold = null;
                        if (!this.buffer_transform) {
                            if (oldpaint != null) {
                                g.drawLine((int)oldpaint.getX(), (int)oldpaint.getY(), (int)paint.getX(), (int)paint.getY());
                            }
                        } else {
                            buffer[value] = paint;
                        }
                    }
                }
                ++value;
            }
        }
        if (this.buffer_transform && !this.getStopFlag()) {
            value = 1;
            while (value < this.model.getDataSetLength(set) && this.buffer_transform && !this.getStopFlag()) {
                if (buffer[value] != null && buffer[value - 1] != null) {
                    g.drawLine((int)buffer[value - 1].getX(), (int)buffer[value - 1].getY(), (int)buffer[value].getX(), (int)buffer[value].getY());
                }
                ++value;
            }
        }
        g.setStroke(backupStroke);
    }

    private void drawmarkers(AffineTransform yaxis1, int set, Graphics2D g) {
        RectangularShape shape;
        int value;
        Point2D paint = new Point2D.Float(0.0f, 0.0f);
        boolean numericalcolumns = this.model.isColumnNumeric();
        float modelVal = 0.0f;
        Point2D[] buffer = null;
        if (this.buffer_transform) {
            buffer = (Point2D[])this.transformed.get(set);
        }
        g.setColor(this.rcm.getColor(set));
        if (!yaxis1.equals(this.last) || !this.buffer_transform) {
            value = 0;
            while (value < this.model.getDataSetLength(set)) {
                Point2D.Float val;
                modelVal = this.model.getValueAt(set, value).floatValue();
                if (!Float.isNaN(modelVal) && (paint = yaxis1.transform(val = numericalcolumns ? new Point2D.Float(((Number)this.model.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal), null)) != null) {
                    if (!this.buffer_transform) {
                        shape = this.rcm.getShape(set);
                        shape.setFrame(paint.getX() - this.shapeSize / 2.0, paint.getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                        g.fill(shape);
                    } else {
                        buffer[value] = paint;
                    }
                    if (this.getStopFlag()) break;
                }
                ++value;
            }
        }
        if (this.buffer_transform && !this.getStopFlag()) {
            value = 0;
            while (value < this.model.getDataSetLength(set) && this.buffer_transform) {
                if (buffer[value] != null) {
                    shape = this.rcm.getShape(set);
                    shape.setFrame(buffer[value].getX() - this.shapeSize / 2.0, buffer[value].getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                    g.fill(shape);
                    if (this.getStopFlag()) break;
                }
                ++value;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setChartDataModel(ChartDataModel model) {
        this.model = (MultiScatterDataModel)model;
    }

    @Override
    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    @Override
    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    @Override
    public void setCoordSystem(CoordSystem cs) {
        this.coord = cs;
    }

    @Override
    public AffineTransform getTransform(int axis) {
        return this.getCoordSystem().getTransform(axis);
    }

    @Override
    public void setRowColorModel(RowColorModel rcm) {
        this.rcm = rcm;
    }

    @Override
    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    public void fireDataUpdate() {
        this.last = null;
        this.transformed = null;
    }

    public void setAllowBuffer(boolean value) {
        this.buffer_transform = value;
    }
}

