/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.SimpleStrokeDefs;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.MultiScatterDataModelConstraints;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class MultiScatterDataModel
implements ChartDataModel {
    private ArrayList<DataSet> data = null;
    private ArrayList<String> names = null;
    private ArrayList<SeriesProperties> properties = null;
    protected EventListenerList listener = new EventListenerList();
    protected boolean autoscale = true;
    protected Double manual_max_x;
    protected Double manual_min_x;
    protected Double manual_max_y;
    protected Double manual_min_y;
    private Double max_x;
    private Double max_y;
    private Double min_x;
    private Double min_y;
    protected ChartDataModelConstraints constraints = null;

    public MultiScatterDataModel() {
        this.data = new ArrayList();
        this.names = new ArrayList();
        this.properties = new ArrayList();
        this.clearBuffers();
        this.constraints = new MultiScatterDataModelConstraints(this);
    }

    public void addData(double[] x, double[] y, String name) {
        this.names.add(name);
        this.properties.add(new SeriesProperties());
        this.data.add(new DataSet(x, y));
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void addData(double[][] xy, String name) {
        this.names.add(name);
        this.properties.add(new SeriesProperties());
        this.data.add(new DataSet(xy));
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void removeData(String name) {
        int i = 0;
        while (i < this.names.size()) {
            String this_name = this.names.get(i);
            if (this_name.compareTo(name) == 0) {
                this.removeData(i);
                break;
            }
            ++i;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void updateData(String name, double[] x, double[] y) {
        int i = 0;
        while (i < this.names.size()) {
            String this_name = this.names.get(i);
            if (this_name.compareTo(name) == 0) {
                this.data.set(i, new DataSet(x, y));
                break;
            }
            ++i;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void updateData(String name, double[][] xy) {
        int i = 0;
        while (i < this.names.size()) {
            String this_name = this.names.get(i);
            if (this_name.compareTo(name) == 0) {
                this.data.set(i, new DataSet(xy));
                break;
            }
            ++i;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public boolean isSeries(String name) {
        boolean return_val = false;
        int i = 0;
        while (i < this.names.size()) {
            String this_name = this.names.get(i);
            if (this_name.compareTo(name) == 0) {
                return_val = true;
                break;
            }
            ++i;
        }
        return return_val;
    }

    public void removeData(int i) {
        if (i > this.names.size() || i > this.data.size()) {
            return;
        }
        this.names.remove(i);
        this.data.remove(i);
        if (i < this.properties.size()) {
            this.properties.remove(i);
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public int getNumberSeries() {
        return Math.min(this.names.size(), this.data.size());
    }

    @Override
    public void removeChartDataModelListener(ChartDataModelListener l) {
        this.listener.remove(ChartDataModelListener.class, l);
    }

    @Override
    public void addChartDataModelListener(ChartDataModelListener l) {
        this.listener.add(ChartDataModelListener.class, l);
    }

    @Override
    public void setAutoScale(boolean b) {
        if (!b) {
            this.setMaximumValueX(new Double(this.getMaxXValue()));
            this.setMinimumValueX(new Double(this.getMinXValue()));
            this.setMaximumValueY(new Double(this.getMaxYValue()));
            this.setMinimumValueY(new Double(this.getMinYValue()));
        }
        this.autoscale = b;
    }

    @Override
    public boolean isAutoScale() {
        return this.autoscale;
    }

    @Override
    public void setManualScale(boolean b) {
        this.setAutoScale(!b);
    }

    @Override
    public boolean isManualScale() {
        return !this.isAutoScale();
    }

    @Override
    public void setMaximumColumnValue(double d) {
        this.manual_max_x = new Double(d);
    }

    @Override
    public void setMinimumColumnValue(double d) {
        this.manual_min_x = new Double(d);
    }

    @Override
    public void setMaximumValue(Number n) {
        this.manual_max_y = new Double(n.doubleValue());
    }

    @Override
    public void setMinimumValue(Number n) {
        this.manual_min_y = new Double(n.doubleValue());
    }

    @Override
    public double getManualMaximumColumnValue() {
        try {
            return this.manual_max_x;
        }
        catch (NullPointerException npe) {
            return Double.NaN;
        }
    }

    @Override
    public double getManualMinimumColumnValue() {
        try {
            return this.manual_min_x;
        }
        catch (NullPointerException npe) {
            return Double.NaN;
        }
    }

    @Override
    public Number getManualMaximumValue() {
        return this.manual_max_y;
    }

    @Override
    public Number getManualMinimumValue() {
        return this.manual_min_y;
    }

    @Override
    public Number getManualMinimumX() {
        return this.manual_min_x;
    }

    @Override
    public Number getManualMaximumX() {
        return this.manual_max_x;
    }

    @Override
    public Number getManualMinimumY() {
        return this.manual_min_y;
    }

    @Override
    public Number getManualMaximumY() {
        return this.manual_max_y;
    }

    @Override
    public void setMaximumValueX(Number n) {
        this.manual_max_x = n instanceof Double ? (Double)n : (n == null ? null : new Double(n.doubleValue()));
    }

    @Override
    public void setMaximumValueY(Number n) {
        this.manual_max_y = n instanceof Double ? (Double)n : (n == null ? null : new Double(n.doubleValue()));
    }

    @Override
    public void setMinimumValueX(Number n) {
        this.manual_min_x = n instanceof Double ? (Double)n : (n == null ? null : new Double(n.doubleValue()));
    }

    @Override
    public void setMinimumValueY(Number n) {
        this.manual_min_y = n instanceof Double ? (Double)n : (n == null ? null : new Double(n.doubleValue()));
    }

    @Override
    public boolean isColumnNumeric() {
        return true;
    }

    @Override
    public int getDataSetLength(int set) {
        if (set > this.data.size()) {
            return -1;
        }
        return this.data.get(set).size();
    }

    @Override
    public String getDataSetName(int set) {
        if (set > this.names.size()) {
            return null;
        }
        return this.names.get(set);
    }

    public int getDataSetIndex(String series) {
        int i = 0;
        while (i < this.names.size()) {
            if (this.names.get(i).compareTo(series) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Number getValueAt(int set, int index) {
        if (set > this.data.size()) {
            return null;
        }
        return new Double(this.data.get(set).getY(index));
    }

    @Override
    public void setValueAt(int set, int index, Object value) {
        if (set > this.data.size()) {
            return;
        }
        this.clearBuffers();
    }

    @Override
    public Class getColumnClass() {
        return Number.class;
    }

    @Override
    public Object getColumnValueAt(int col) {
        return null;
    }

    @Override
    public Object getColumnValueAt(int set, int col) {
        if (set > this.data.size()) {
            return null;
        }
        return new Double(this.data.get(set).getX(col));
    }

    @Override
    public int getDataSetNumber() {
        return this.getNumberSeries();
    }

    @Override
    public int getAxisBinding(int set) {
        return 0;
    }

    @Override
    public void setAxisBinding(int set, int axis) {
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        return this.constraints;
    }

    @Override
    public void setChartDataModelConstraints(int axis, ChartDataModelConstraints constraints) {
        this.constraints = constraints;
    }

    public double getMaxXValue() {
        if (this.max_x == null) {
            double return_val = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                double max_for_one = this.data.get(i).getMaxX();
                if (max_for_one > return_val) {
                    return_val = max_for_one;
                }
                ++i;
            }
            this.max_x = new Double(return_val);
            this.checkConstraintSafety();
        }
        return this.max_x;
    }

    public double getMaxYValue() {
        if (this.max_y == null) {
            double return_val = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                double max_for_one = this.data.get(i).getMaxY();
                if (max_for_one > return_val) {
                    return_val = max_for_one;
                }
                ++i;
            }
            this.max_y = new Double(return_val);
            this.checkConstraintSafety();
        }
        return this.max_y;
    }

    public double getMinXValue() {
        if (this.min_x == null) {
            double return_val = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                double min_for_one = this.data.get(i).getMinX();
                if (min_for_one < return_val) {
                    return_val = min_for_one;
                }
                ++i;
            }
            this.min_x = new Double(return_val);
            this.checkConstraintSafety();
        }
        return this.min_x;
    }

    public double getMinYValue() {
        if (this.min_y == null) {
            double return_val = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                double min_for_one = this.data.get(i).getMinY();
                if (min_for_one < return_val) {
                    return_val = min_for_one;
                }
                ++i;
            }
            this.min_y = new Double(return_val);
            this.checkConstraintSafety();
        }
        return this.min_y;
    }

    public void setSeriesMarker(String name, boolean on_or_off) {
        int i = 0;
        while (i < this.getDataSetNumber()) {
            if (name.compareTo(this.getDataSetName(i)) == 0) break;
            ++i;
        }
        if (i < this.getDataSetNumber()) {
            SeriesProperties this_series = this.properties.get(i);
            if (on_or_off) {
                this_series.setMarkerOn();
            } else {
                this_series.setMarkerOff();
            }
        }
    }

    public int getSeriesIndex(String name) {
        int i = 0;
        while (i < this.getDataSetNumber()) {
            if (name.compareTo(this.getDataSetName(i)) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSeriesLine(String name, boolean on_or_off) {
        int i = this.getSeriesIndex(name);
        if (i < this.getDataSetNumber() && i >= 0) {
            SeriesProperties this_series = this.properties.get(i);
            if (on_or_off) {
                this_series.setLineOn();
            } else {
                this_series.setLineOff();
            }
        }
    }

    public boolean getSeriesMarker(String series) {
        return this.getSeriesMarker(this.getDataSetIndex(series));
    }

    public boolean getSeriesMarker(int set) {
        if (set > this.properties.size() || set < 0) {
            return false;
        }
        SeriesProperties this_series = this.properties.get(set);
        return this_series.getMarker();
    }

    public boolean getSeriesLine(String series) {
        return this.getSeriesLine(this.getDataSetIndex(series));
    }

    public boolean getSeriesLine(int set) {
        if (set > this.properties.size() || set < 0) {
            return false;
        }
        SeriesProperties this_series = this.properties.get(set);
        return this_series.getLine();
    }

    public String getSeriesLineStyle(int set) {
        if (set > this.properties.size()) {
            return null;
        }
        SeriesProperties this_series = this.properties.get(set);
        return this_series.getLineStyle();
    }

    public void setSeriesLineStyle(String value, int set) {
        if (set > this.properties.size()) {
            return;
        }
        SeriesProperties this_series = this.properties.get(set);
        this_series.setLineStyle(value);
    }

    public void setSeriesLineStyle(String value, String name) {
        this.setSeriesLineStyle(value, this.getSeriesIndex(name));
    }

    public String getSeriesLineStyle(String name) {
        return this.getSeriesLineStyle(this.getSeriesIndex(name));
    }

    public void clearDataModel() {
        this.data.clear();
        this.names.clear();
        this.properties.clear();
        this.clearBuffers();
    }

    @Override
    public void fireChartDataModelChangedEvent(Object src) {
        ChartDataModelEvent e = new ChartDataModelEvent(src);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == ChartDataModelListener.class) {
                ((ChartDataModelListener)ls[i + 1]).chartDataChanged(e);
            }
            i -= 2;
        }
        this.clearBuffers();
    }

    private void clearBuffers() {
        this.max_x = null;
        this.max_y = null;
        this.min_x = null;
        this.min_y = null;
    }

    private void checkConstraintSafety() {
        Double hold;
        if (this.getMaxXValue() <= this.getMinXValue()) {
            if (this.min_x.compareTo(this.max_x) == 0) {
                if (this.min_x == 0.0) {
                    this.min_x = new Double(-1.0);
                    this.max_x = new Double(1.0);
                } else {
                    this.min_x = new Double(0.9 * this.min_x);
                    this.max_x = new Double(1.1 * this.max_x);
                }
            }
            if (this.min_x.compareTo(this.max_x) > 0) {
                hold = this.min_x;
                this.min_x = this.max_x;
                this.max_x = hold;
            }
        }
        if (this.getMaxYValue() <= this.getMinYValue()) {
            if (this.min_y.compareTo(this.max_y) == 0) {
                if (this.min_y == 0.0) {
                    this.min_y = new Double(-1.0);
                    this.max_y = new Double(1.0);
                } else {
                    this.min_y = new Double(0.9 * this.min_y);
                    this.max_y = new Double(1.1 * this.max_y);
                }
            }
            if (this.min_y.compareTo(this.max_y) > 0) {
                hold = this.min_y;
                this.min_y = this.max_x;
                this.max_y = hold;
            }
        }
    }

    private class DataSet {
        private ArrayList<Double> xvalues = new ArrayList();
        private ArrayList<Double> yvalues = new ArrayList();

        public DataSet() {
        }

        public DataSet(double[] x, double[] y) {
            this();
            this.setXValues(x);
            this.setYValues(y);
        }

        public DataSet(double[][] xy) {
            this();
            this.setXYValues(xy);
        }

        public int size() {
            return Math.min(this.xvalues.size(), this.yvalues.size());
        }

        public double getX(int i) {
            if (i > this.xvalues.size()) {
                return -1.0;
            }
            return this.xvalues.get(i);
        }

        public double getY(int i) {
            if (i > this.yvalues.size()) {
                return -1.0;
            }
            return this.yvalues.get(i);
        }

        public void setXValues(double[] inputs) {
            int i = 0;
            while (i < inputs.length) {
                this.xvalues.add(new Double(inputs[i]));
                ++i;
            }
        }

        public void setYValues(double[] inputs) {
            int i = 0;
            while (i < inputs.length) {
                this.yvalues.add(new Double(inputs[i]));
                ++i;
            }
        }

        public void setXYValues(double[][] inputs) {
            if (inputs[0].length < 2) {
                return;
            }
            int i = 0;
            while (i < inputs.length) {
                this.xvalues.add(new Double(inputs[i][0]));
                this.yvalues.add(new Double(inputs[i][1]));
                ++i;
            }
        }

        public void setXValue(double value, int i) {
            if (i > this.xvalues.size()) {
                return;
            }
            this.xvalues.set(i, new Double(value));
        }

        public void setYValue(double value, int i) {
            if (i > this.yvalues.size()) {
                return;
            }
            this.yvalues.set(i, new Double(value));
        }

        public double getMaxX() {
            double current = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.xvalues.size()) {
                if (this.xvalues.get(i) > current) {
                    current = this.xvalues.get(i);
                }
                ++i;
            }
            return current;
        }

        public double getMaxY() {
            double current = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.yvalues.size()) {
                if (this.yvalues.get(i) > current) {
                    current = this.yvalues.get(i);
                }
                ++i;
            }
            return current;
        }

        public double getMinX() {
            double current = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.xvalues.size()) {
                if (this.xvalues.get(i) < current) {
                    current = this.xvalues.get(i);
                }
                ++i;
            }
            return current;
        }

        public double getMinY() {
            double current = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.yvalues.size()) {
                if (this.yvalues.get(i) < current) {
                    current = this.yvalues.get(i);
                }
                ++i;
            }
            return current;
        }
    }

    private class SeriesProperties {
        private boolean show_marker = false;
        private boolean show_line = true;
        private String line_description = SimpleStrokeDefs.getDefaultStrokeDescription();

        public void setLineStyle(String value) {
            this.line_description = value;
        }

        public String getLineStyle() {
            return this.line_description;
        }

        public void setMarkerOn() {
            this.show_marker = true;
        }

        public void setMarkerOff() {
            this.show_marker = false;
        }

        public void setLineOn() {
            this.show_line = true;
        }

        public void setLineOff() {
            this.show_line = false;
        }

        public boolean getMarker() {
            return this.show_marker;
        }

        public boolean getLine() {
            return this.show_line;
        }
    }
}

