/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.server.PlanType;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.StatusType;
import com.pomodorotechnique.server.WorkitemType;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class StatisticsWindow
extends JDialog {
    private final PlanType plan;
    private JButton closeButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel1;
    private JLabel headerTextLabel1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea statisticsText;

    public StatisticsWindow(Frame parent, boolean modal, PlanType plan) {
        super(parent, modal);
        this.plan = plan;
        this.initComponents();
        this.calculateStatistics();
        this.getRootPane().setDefaultButton(this.closeButton);
        Util.decorate(this, true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.closeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.statisticsText = new JTextArea();
        this.headerPanel1 = new JPanel();
        this.headerTextLabel1 = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(StatisticsWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(StatisticsWindow.class, this);
        this.closeButton.setAction(actionMap.get("close"));
        this.closeButton.setText(resourceMap.getString("closeButton.text", new Object[0]));
        this.closeButton.setName("closeButton");
        this.jScrollPane1.setName("jScrollPane1");
        this.statisticsText.setColumns(20);
        this.statisticsText.setEditable(false);
        this.statisticsText.setRows(5);
        this.statisticsText.setName("statisticsText");
        this.jScrollPane1.setViewportView(this.statisticsText);
        this.headerPanel1.setBackground(resourceMap.getColor("headerPanel1.background"));
        this.headerPanel1.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel1.border.lineColor")));
        this.headerPanel1.setName("headerPanel1");
        this.headerTextLabel1.setFont(this.headerTextLabel1.getFont().deriveFont((float)this.headerTextLabel1.getFont().getSize() + 7.0f));
        this.headerTextLabel1.setText(resourceMap.getString("headerTextLabel1.text", new Object[0]));
        this.headerTextLabel1.setName("headerTextLabel1");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanel1Layout = new GroupLayout(this.headerPanel1);
        this.headerPanel1.setLayout(headerPanel1Layout);
        headerPanel1Layout.setHorizontalGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel1, -1, 136, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanel1Layout.setVerticalGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addComponent(this.headerTextLabel1, -1, 68, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 369, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.LEADING).addComponent(this.headerPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 254, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                StatisticsWindow dialog = new StatisticsWindow((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Action
    public void close() {
        this.setVisible(false);
    }

    private void calculateStatistics() {
        if (this.plan.getWorkitem().isEmpty()) {
            this.statisticsText.setText("The plan is empty - nothing to analyze.");
            return;
        }
        int allWi = 0;
        int plannedWi = 0;
        int completedWi = 0;
        int allPom = 0;
        int plannedPom = 0;
        int completedPom = 0;
        int failedPom = 0;
        int allInter = 0;
        boolean avgIntLen = false;
        for (WorkitemType w : this.plan.getWorkitem()) {
            ++allWi;
            if (w.getSection().equalsIgnoreCase("planned")) {
                ++plannedWi;
            }
            if (w.getStatus().equals((Object)StatusType.COMPLETED)) {
                ++completedWi;
            }
            for (PomodoroType p : w.getPomodoro()) {
                ++allPom;
                if (p.isPlanned()) {
                    ++plannedPom;
                }
                if (p.getStatus().equals((Object)StatusType.COMPLETED)) {
                    ++completedPom;
                } else if (p.getStatus().equals((Object)StatusType.FAILED)) {
                    ++failedPom;
                }
                allInter += p.getInterruption().size();
            }
        }
        this.statisticsText.setText("Work items\n * Total: " + allWi + "\n" + " * Planned: " + plannedWi + " (" + 100 * plannedWi / allWi + "%)\n" + " * Unplanned: " + (allWi - plannedWi) + " (" + 100 * (allWi - plannedWi) / allWi + "%)\n" + " * Completed: " + completedWi + " (" + 100 * completedWi / allWi + "%)\n" + " * Incomplete: " + (allWi - completedWi) + " (" + 100 * (allWi - completedWi) / allWi + "%)\n" + " * Average Pomodoros: " + allPom / allWi + "\n" + "\n" + "Pomodoros\n" + " * Total: " + allPom + "\n" + " * Planned: " + plannedPom + " (" + 100 * plannedPom / allPom + "%)\n" + " * Unplanned: " + (allPom - plannedPom) + " (" + 100 * (allPom - plannedPom) / allPom + "%)\n" + " * Completed: " + completedPom + " (" + 100 * completedPom / allPom + "%)\n" + " * Failed: " + failedPom + " (" + 100 * failedPom / allPom + "%)\n" + " * Others: " + (allPom - completedPom - failedPom) + " (" + 100 * (allPom - completedPom - failedPom) / allPom + "%)\n" + " * Average Interruptions: " + allInter / allPom + "\n" + "\n" + "Interruptions\n" + " * Total: " + allInter + "\n");
    }
}

