/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.core.imp;

class PythonTraceFunction
extends TraceFunction {
    PyObject tracefunc;

    PythonTraceFunction(PyObject pyObject) {
        this.tracefunc = pyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceFunction safeCall(PyFrame pyFrame, String string2, PyObject pyObject) {
        Class clazz = imp.class;
        synchronized (clazz) {
            PythonTraceFunction pythonTraceFunction = this;
            synchronized (pythonTraceFunction) {
                ThreadState threadState = Py.getThreadState();
                if (threadState.tracing) {
                    return null;
                }
                if (this.tracefunc == null) {
                    return null;
                }
                PyObject pyObject2 = null;
                try {
                    threadState.tracing = true;
                    pyObject2 = this.tracefunc.__call__((PyObject)pyFrame, new PyString(string2), pyObject);
                }
                catch (PyException pyException) {
                    pyFrame.tracefunc = null;
                    threadState.systemState.tracefunc = null;
                    threadState.systemState.profilefunc = null;
                    throw pyException;
                }
                finally {
                    threadState.tracing = false;
                }
                if (pyObject2 == this.tracefunc) {
                    return this;
                }
                if (pyObject2 == Py.None) {
                    return null;
                }
                return new PythonTraceFunction(pyObject2);
            }
        }
    }

    public TraceFunction traceCall(PyFrame pyFrame) {
        return this.safeCall(pyFrame, "call", Py.None);
    }

    public TraceFunction traceReturn(PyFrame pyFrame, PyObject pyObject) {
        return this.safeCall(pyFrame, "return", pyObject);
    }

    public TraceFunction traceLine(PyFrame pyFrame, int n) {
        return this.safeCall(pyFrame, "line", Py.None);
    }

    public TraceFunction traceException(PyFrame pyFrame, PyException pyException) {
        return this.safeCall(pyFrame, "exception", new PyTuple(new PyObject[]{pyException.type, pyException.value, pyException.traceback}));
    }
}

