/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class PyXRange
extends PySequence {
    public int start;
    public int stop;
    public int step;
    int cycleLength;
    int copies;

    public PyXRange(int n, int n2, int n3) {
        if (n3 == 0) {
            throw Py.ValueError("zero step for xrange()");
        }
        this.start = n;
        this.stop = n2;
        this.step = n3;
        int n4 = n3 + (n3 > 0 ? -1 : 1);
        this.cycleLength = (n2 - n + n4) / n3;
        if (this.cycleLength < 0) {
            this.cycleLength = 0;
        }
        this.stop = n + this.cycleLength * n3;
        this.copies = 1;
    }

    public int __len__() {
        return this.cycleLength * this.copies;
    }

    private int getInt(int n) {
        if (this.cycleLength == 0) {
            return this.start;
        }
        return this.start + n % this.cycleLength * this.step;
    }

    protected PyObject pyget(int n) {
        return new PyInteger(this.getInt(n));
    }

    protected PyObject getslice(int n, int n2, int n3) {
        Py.DeprecationWarning("xrange object slicing is deprecated; convert to list instead");
        if (this.copies != 1) {
            throw Py.TypeError("cannot slice a replicated range");
        }
        int n4 = PyXRange.sliceLength(n, n2, n3);
        int n5 = this.getInt(n);
        int n6 = this.step * n3;
        int n7 = n5 + n6 * n4;
        return new PyXRange(n5, n7, n6);
    }

    protected PyObject repeat(int n) {
        Py.DeprecationWarning("xrange object multiplication is deprecated; convert to list instead");
        PyXRange pyXRange = new PyXRange(this.start, this.stop, this.step);
        pyXRange.copies = this.copies * n;
        return pyXRange;
    }

    public PyObject __add__(PyObject pyObject) {
        throw Py.TypeError("cannot concatenate xrange objects");
    }

    public PyObject __findattr__(String string2) {
        String string3 = "xrange object's 'start', 'stop' and 'step' attributes are deprecated";
        if (string2 == "start") {
            Py.DeprecationWarning(string3);
            return Py.newInteger(this.start);
        }
        if (string2 == "stop") {
            Py.DeprecationWarning(string3);
            return Py.newInteger(this.stop);
        }
        if (string2 == "step") {
            Py.DeprecationWarning(string3);
            return Py.newInteger(this.step);
        }
        return super.__findattr__(string2);
    }

    public int hashCode() {
        return this.stop ^ this.start ^ this.step;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("xrange(");
        if (this.start != 0) {
            stringBuffer.append(this.start);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.__len__() * this.step + this.start);
        if (this.step != 1) {
            stringBuffer.append(", ");
            stringBuffer.append(this.step);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public PyList tolist() {
        Py.DeprecationWarning("xrange.tolist() is deprecated; use list(xrange) instead");
        PyList pyList = new PyList();
        int n = this.__len__();
        for (int i = 0; i < n; ++i) {
            pyList.append(this.pyget(i));
        }
        return pyList;
    }
}

