/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.sql.DBStrings;

public class SQLUtil {
    private static final ArrayList<String> reservedDBWords = new ArrayList<String>(Arrays.asList("key"));
    private static ArrayList<String> allFields = null;

    private SQLUtil() {
    }

    public static void refreshFields() {
        if (allFields == null) {
            allFields = new ArrayList();
        } else {
            allFields.clear();
        }
        SQLUtil.uniqueInsert(allFields, BibtexFields.getAllFieldNames());
    }

    public static ArrayList<String> getAllFields() {
        if (allFields == null) {
            SQLUtil.refreshFields();
        }
        return allFields;
    }

    public static String getFieldStr() {
        String fieldstr = "";
        String field = "";
        for (int i = 0; i < SQLUtil.getAllFields().size(); ++i) {
            field = allFields.get(i);
            if (i > 0) {
                fieldstr = fieldstr + ", ";
            }
            if (reservedDBWords.contains(field)) {
                field = field + "_";
            }
            fieldstr = fieldstr + field;
        }
        return fieldstr;
    }

    private static ArrayList<String> uniqueInsert(ArrayList<String> list, String[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (list.contains(array[i])) continue;
                list.add(array[i]);
            }
        }
        return list;
    }

    public static String fieldsAsCols(ArrayList<String> fields, String datatype) {
        String str = "";
        String field = "";
        ListIterator<String> li = fields.listIterator();
        while (li.hasNext()) {
            field = li.next();
            if (reservedDBWords.contains(field)) {
                field = field + "_";
            }
            str = str + field + datatype;
            if (!li.hasNext()) continue;
            str = str + ", ";
        }
        return str;
    }

    public static ArrayList<String> setFieldRequirement(ArrayList<String> allFields, List<String> reqFields, List<String> optFields, List<String> utiFields, ArrayList<String> origList) {
        String currentField = null;
        for (int i = 0; i < allFields.size(); ++i) {
            currentField = allFields.get(i);
            if (reqFields.contains(currentField)) {
                origList.set(i, "req");
                continue;
            }
            if (optFields.contains(currentField)) {
                origList.set(i, "opt");
                continue;
            }
            if (!utiFields.contains(currentField)) continue;
            origList.set(i, "uti");
        }
        return origList;
    }

    public static String getExceptionMessage(Exception ex) {
        String msg = null;
        msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
        return msg;
    }

    public static ResultSet queryAllFromTable(Connection conn, String tableName) throws SQLException {
        String query = "SELECT * FROM " + tableName + ";";
        Statement res = (Statement)SQLUtil.processQueryWithResults(conn, query);
        return res.getResultSet();
    }

    public static void processQuery(Object out, String dml) throws SQLException {
        if (out instanceof PrintStream) {
            PrintStream fout = (PrintStream)out;
            fout.println(dml);
        }
        if (out instanceof Connection) {
            Connection conn = (Connection)out;
            SQLUtil.executeQuery(conn, dml);
        }
    }

    public static Object processQueryWithResults(Object out, String query) throws SQLException {
        if (out instanceof PrintStream) {
            PrintStream fout = (PrintStream)out;
            fout.println(query);
            return fout;
        }
        if (out instanceof Connection) {
            Connection conn = (Connection)out;
            return SQLUtil.executeQueryWithResults(conn, query);
        }
        return null;
    }

    public static String createJDBCurl(DBStrings dbStrings, boolean withDBName) {
        String url = "";
        url = "jdbc:" + dbStrings.getServerType().toLowerCase() + "://" + dbStrings.getServerHostname() + (withDBName ? "/" + dbStrings.getDatabase() : "");
        return url;
    }

    public static String processQueryWithSingleResult(Connection conn, String query) throws SQLException {
        ResultSet rs = SQLUtil.executeQueryWithResults(conn, query).getResultSet();
        rs.next();
        String result = rs.getString(1);
        rs.getStatement().close();
        return result;
    }

    public static void executeQuery(Connection conn, String qry) throws SQLException {
        Statement stmnt = conn.createStatement();
        stmnt.execute(qry);
        SQLWarning warn = stmnt.getWarnings();
        if (warn != null) {
            System.err.println(warn.toString());
        }
        stmnt.close();
    }

    public static Statement executeQueryWithResults(Connection conn, String qry) throws SQLException {
        Statement stmnt = conn.createStatement();
        stmnt.executeQuery(qry);
        SQLWarning warn = stmnt.getWarnings();
        if (warn != null) {
            System.err.println(warn.toString());
        }
        return stmnt;
    }
}

